/*
 * Decompiled with CFR 0.152.
 */
package org.gitlab4j.api.models;

import com.fasterxml.jackson.annotation.JsonIgnore;
import java.util.Date;
import org.gitlab4j.api.GitLabApiForm;
import org.gitlab4j.api.utils.ISO8601;
import org.gitlab4j.api.utils.JacksonJson;

public class ChangelogPayload {
    private String version;
    private String from;
    private String to;
    private Date date;
    private String branch;
    private String trailer;
    private String file;
    private String message;

    public ChangelogPayload(String version) {
        this.version = version;
    }

    @JsonIgnore
    public GitLabApiForm getFormData() {
        return new GitLabApiForm().withParam("version", this.version, true).withParam("from", this.from).withParam("to", this.to).withParam("date", ISO8601.dateOnly(this.date)).withParam("branch", this.branch).withParam("trailer", this.trailer).withParam("file", this.file).withParam("message", this.message);
    }

    public String getVersion() {
        return this.version;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    public String getFrom() {
        return this.from;
    }

    public void setFrom(String from) {
        this.from = from;
    }

    public String getTo() {
        return this.to;
    }

    public void setTo(String to) {
        this.to = to;
    }

    public Date getDate() {
        return this.date;
    }

    public void setDate(Date date) {
        this.date = date;
    }

    public String getBranch() {
        return this.branch;
    }

    public void setBranch(String branch) {
        this.branch = branch;
    }

    public String getTrailer() {
        return this.trailer;
    }

    public void setTrailer(String trailer) {
        this.trailer = trailer;
    }

    public String getFile() {
        return this.file;
    }

    public void setFile(String file) {
        this.file = file;
    }

    public String getMessage() {
        return this.message;
    }

    public void setMessage(String message) {
        this.message = message;
    }

    public String toString() {
        return JacksonJson.toJsonString(this);
    }
}

