/*
 * Decompiled with CFR 0.152.
 */
package hprose.io.access;

import hprose.common.HproseException;
import java.io.ObjectStreamClass;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Comparator;
import java.util.concurrent.ConcurrentHashMap;

public class ConstructorAccessor {
    private static final ConcurrentHashMap<Class<?>, Constructor<?>> ctorCache;
    private static final ConcurrentHashMap<Constructor<?>, Object[]> argsCache;
    private static final Long longZero;
    private static final Object[] nullArgs;
    private static final Short shortZero;
    private static final Double doubleZero;
    private static final Byte byteZero;
    private static final Integer intZero;
    private static final Float floatZero;
    private static final Character charZero;
    private static final Constructor<Object> nullCtor;
    private static final Method newInstance;

    private static Object[] getArgs(Constructor<?> ctor) {
        Object[] args = argsCache.get(ctor);
        if (args == null) {
            Class<?>[] params = ctor.getParameterTypes();
            args = new Object[params.length];
            for (int i = 0; i < params.length; ++i) {
                Class<?> type = params[i];
                args[i] = Integer.TYPE.equals(type) || Integer.class.equals(type) ? intZero : (Long.TYPE.equals(type) || Long.class.equals(type) ? longZero : (Byte.TYPE.equals(type) || Byte.class.equals(type) ? byteZero : (Short.TYPE.equals(type) || Short.class.equals(type) ? shortZero : (Float.TYPE.equals(type) || Float.class.equals(type) ? floatZero : (Double.TYPE.equals(type) || Double.class.equals(type) ? doubleZero : (Character.TYPE.equals(type) || Character.class.equals(type) ? (Comparable<Character>)charZero : (Comparable<Character>)(Boolean.TYPE.equals(type) || Boolean.class.equals(type) ? Boolean.FALSE : null)))))));
            }
            argsCache.put(ctor, args);
        }
        return args;
    }

    public static final <T> T newInstance(Class<T> type) throws HproseException {
        Constructor<Object> ctor = ctorCache.get(type);
        if (ctor == null) {
            Constructor<?>[] ctors = type.getDeclaredConstructors();
            Arrays.sort(ctors, new ConstructorComparator());
            for (Constructor<?> c : ctors) {
                try {
                    c.setAccessible(true);
                    Object obj = c.newInstance(ConstructorAccessor.getArgs(c));
                    ctorCache.put(type, c);
                    return (T)obj;
                }
                catch (Exception exception) {
                }
            }
            ctor = nullCtor;
            ctorCache.put(type, ctor);
        }
        try {
            if (ctor == nullCtor) {
                return (T)newInstance.invoke((Object)ObjectStreamClass.lookup(type), nullArgs);
            }
            return (T)ctor.newInstance(ConstructorAccessor.getArgs(ctor));
        }
        catch (Exception ex) {
            throw new HproseException(ex);
        }
    }

    static {
        Method _newInstance;
        Constructor _nullCtor;
        ctorCache = new ConcurrentHashMap();
        argsCache = new ConcurrentHashMap();
        longZero = 0L;
        nullArgs = new Object[0];
        shortZero = 0;
        doubleZero = 0.0;
        byteZero = 0;
        intZero = 0;
        floatZero = Float.valueOf(0.0f);
        charZero = Character.valueOf('\u0000');
        try {
            _nullCtor = Object.class.getConstructor(null);
        }
        catch (Exception e) {
            _nullCtor = null;
        }
        assert (_nullCtor != null);
        nullCtor = _nullCtor;
        try {
            _newInstance = ObjectStreamClass.class.getDeclaredMethod("newInstance", new Class[0]);
            _newInstance.setAccessible(true);
        }
        catch (Exception e) {
            _newInstance = null;
        }
        assert (_newInstance != null);
        newInstance = _newInstance;
    }

    private static class ConstructorComparator
    implements Comparator<Constructor<?>> {
        private ConstructorComparator() {
        }

        @Override
        public int compare(Constructor<?> o1, Constructor<?> o2) {
            return o1.getParameterTypes().length - o2.getParameterTypes().length;
        }
    }
}

