/*
 * Decompiled with CFR 0.152.
 */
package hprose.io.serialize;

import hprose.io.serialize.ReferenceSerializer;
import hprose.io.serialize.ValueWriter;
import hprose.io.serialize.Writer;
import java.io.IOException;
import java.io.OutputStream;

public final class StringBufferSerializer
extends ReferenceSerializer<StringBuffer> {
    public static final StringBufferSerializer instance = new StringBufferSerializer();

    @Override
    public final void serialize(Writer writer, StringBuffer s) throws IOException {
        super.serialize(writer, s);
        OutputStream stream = writer.stream;
        stream.write(115);
        ValueWriter.write(stream, s.toString());
    }

    @Override
    public final void write(Writer writer, StringBuffer obj) throws IOException {
        OutputStream stream = writer.stream;
        switch (obj.length()) {
            case 0: {
                stream.write(101);
                break;
            }
            case 1: {
                ValueWriter.write(stream, obj.charAt(0));
                break;
            }
            default: {
                super.write(writer, obj);
            }
        }
    }
}

