/*
 * Decompiled with CFR 0.152.
 */
package hprose.net;

import hprose.net.Connection;
import java.io.IOException;
import java.nio.channels.CancelledKeyException;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.ClosedSelectorException;
import java.nio.channels.SelectionKey;
import java.nio.channels.Selector;
import java.util.Iterator;
import java.util.Queue;
import java.util.Set;
import java.util.concurrent.ConcurrentLinkedQueue;

public final class Reactor
extends Thread {
    private final Selector selector;
    private final Queue<Connection> connQueue = new ConcurrentLinkedQueue<Connection>();
    private final Queue<Connection> writeQueue = new ConcurrentLinkedQueue<Connection>();

    public Reactor() throws IOException {
        this.selector = Selector.open();
    }

    @Override
    public void run() {
        try {
            while (!this.isInterrupted()) {
                try {
                    this.process();
                    this.dispatch();
                }
                catch (IOException iOException) {}
            }
        }
        catch (ClosedSelectorException closedSelectorException) {
            // empty catch block
        }
    }

    public void close() {
        try {
            Set<SelectionKey> keys = this.selector.keys();
            for (SelectionKey key : keys.toArray(new SelectionKey[0])) {
                Connection conn = (Connection)key.attachment();
                conn.close();
            }
            this.selector.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private void process() {
        Connection conn;
        while ((conn = this.connQueue.poll()) != null) {
            try {
                conn.connected(this, this.selector);
            }
            catch (ClosedChannelException closedChannelException) {}
        }
        while ((conn = this.writeQueue.poll()) != null) {
            conn.send();
        }
    }

    private void dispatch() throws IOException {
        int n = this.selector.select();
        if (n == 0) {
            return;
        }
        Iterator<SelectionKey> it = this.selector.selectedKeys().iterator();
        while (it.hasNext()) {
            SelectionKey key = it.next();
            Connection conn = (Connection)key.attachment();
            it.remove();
            try {
                int readyOps = key.readyOps();
                if ((readyOps & 1) != 0 && !conn.receive() || (readyOps & 4) == 0) continue;
                conn.send();
            }
            catch (CancelledKeyException e) {
                conn.close();
            }
        }
    }

    public void register(Connection conn) {
        this.connQueue.offer(conn);
        this.selector.wakeup();
    }

    public void write(Connection conn) {
        this.writeQueue.offer(conn);
        this.selector.wakeup();
    }
}

