/*
 * Decompiled with CFR 0.152.
 */
package org.hswebframework.reactor.excel;

import java.util.Optional;
import org.hswebframework.reactor.excel.CellDataType;
import org.hswebframework.reactor.excel.SimpleCell;

public interface Cell {
    public long getRowIndex();

    public int getColumnIndex();

    public boolean isEndOfRow();

    public Optional<Object> value();

    default public Optional<String> valueAsText() {
        return this.value().map(String::valueOf);
    }

    public CellDataType getType();

    public static Cell of(int row, int column, Object value) {
        return new SimpleCell(row, column, false, value, CellDataType.AUTO);
    }

    public static Cell of(int row, int column, boolean endOfRow, Object value) {
        return new SimpleCell(row, column, endOfRow, value, CellDataType.AUTO);
    }

    public static Cell of(int row, int column, boolean endOfRow, Object value, CellDataType type) {
        return new SimpleCell(row, column, endOfRow, value, type);
    }
}

