/*
 * Decompiled with CFR 0.152.
 */
package org.hswebframework.reactor.excel.poi;

import java.io.InputStream;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.ss.usermodel.WorkbookFactory;
import org.hswebframework.reactor.excel.BoundedCell;
import org.hswebframework.reactor.excel.ExcelOption;
import org.hswebframework.reactor.excel.poi.NullCell;
import org.hswebframework.reactor.excel.poi.PoiCell;
import org.hswebframework.reactor.excel.spi.ExcelReader;
import reactor.core.publisher.Flux;

public class PoiExcelReader
implements ExcelReader {
    @Override
    public String[] getSupportFormat() {
        return new String[]{"xls", "xlsx"};
    }

    public Flux<BoundedCell> read(InputStream inputStream, ExcelOption ... options) {
        return Flux.create(sink -> {
            try (Workbook wbs = WorkbookFactory.create((InputStream)inputStream);){
                int sheetSize = wbs.getNumberOfSheets();
                block11: for (int x = 0; x < sheetSize; ++x) {
                    Sheet sheet = wbs.getSheetAt(x);
                    int rowNum = sheet.getPhysicalNumberOfRows();
                    if (rowNum <= 0) continue;
                    Row row = sheet.getRow(0);
                    int colNum = row.getPhysicalNumberOfCells();
                    for (int i = 0; i <= rowNum; ++i) {
                        if (sink.isCancelled()) break block11;
                        row = sheet.getRow(i);
                        if (row == null) continue;
                        for (int j = 0; j < colNum - 1; ++j) {
                            Cell cell = row.getCell(j);
                            if (cell == null) {
                                sink.next((Object)new NullCell(x, i, j, false, rowNum, colNum, sheetSize));
                                continue;
                            }
                            sink.next((Object)new PoiCell(x, cell, false));
                        }
                        Cell lastCell = row.getCell(colNum - 1);
                        if (lastCell == null) {
                            sink.next((Object)new NullCell(x, i, colNum - 1, true, rowNum, colNum, sheetSize));
                            continue;
                        }
                        sink.next((Object)new PoiCell(x, row.getCell(colNum - 1), true));
                    }
                }
                sink.complete();
            }
            catch (Throwable e) {
                sink.error(e);
            }
        });
    }

    @Override
    public boolean isSupportMultiSheet() {
        return true;
    }
}

