/*
 * Decompiled with CFR 0.152.
 */
package org.hswebframework.web.logging.aop;

import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.tags.Tag;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Method;
import org.hswebframework.web.aop.MethodInterceptorHolder;
import org.hswebframework.web.logging.LoggerDefine;
import org.hswebframework.web.logging.aop.AccessLoggerParser;
import org.springframework.core.annotation.AnnotatedElementUtils;
import org.springframework.core.annotation.AnnotationUtils;
import org.springframework.util.StringUtils;

public class Swagger3AccessLoggerParser
implements AccessLoggerParser {
    @Override
    public boolean support(Class<?> clazz, Method method) {
        Tag api = (Tag)AnnotationUtils.findAnnotation(clazz, Tag.class);
        Operation operation = (Operation)AnnotationUtils.findAnnotation((Method)method, Operation.class);
        return api != null || operation != null;
    }

    @Override
    public LoggerDefine parse(MethodInterceptorHolder holder) {
        Tag api = (Tag)holder.findAnnotation(Tag.class);
        Operation operation = (Operation)AnnotatedElementUtils.findMergedAnnotation((AnnotatedElement)holder.getMethod(), Operation.class);
        String action = "";
        if (api != null) {
            action = action.concat(api.name());
        }
        if (null != operation) {
            action = StringUtils.isEmpty((Object)action) ? operation.summary() : action + "-" + operation.summary();
        }
        return new LoggerDefine(action, "");
    }
}

