/*
 * Decompiled with CFR 0.152.
 */
package org.hswebframework.web.datasource.strategy;

import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import org.hswebframework.web.datasource.annotation.UseDataSource;
import org.hswebframework.web.datasource.annotation.UseDefaultDataSource;
import org.hswebframework.web.datasource.strategy.CachedDataSourceSwitchStrategyMatcher;
import org.hswebframework.web.datasource.strategy.DataSourceSwitchStrategyMatcher;
import org.hswebframework.web.utils.AnnotationUtils;
import org.springframework.util.StringUtils;

public class AnnotationDataSourceSwitchStrategyMatcher
extends CachedDataSourceSwitchStrategyMatcher {
    static final Set<String> ignoreMethod = new HashSet<String>(Arrays.asList("toString", "clone", "equals"));

    @Override
    public DataSourceSwitchStrategyMatcher.Strategy createStrategyIfMatch(Class target, Method method) {
        boolean support;
        if (ignoreMethod.contains(method.getName())) {
            return null;
        }
        final UseDataSource useDataSource = (UseDataSource)AnnotationUtils.findAnnotation((Class)target, (Method)method, UseDataSource.class);
        final UseDefaultDataSource useDefaultDataSource = (UseDefaultDataSource)AnnotationUtils.findAnnotation((Class)target, (Method)method, UseDefaultDataSource.class);
        boolean bl = support = useDataSource != null || useDefaultDataSource != null;
        if (support) {
            return new DataSourceSwitchStrategyMatcher.Strategy(){

                @Override
                public boolean isUseDefaultDataSource() {
                    return useDefaultDataSource != null;
                }

                @Override
                public boolean isFallbackDefault() {
                    return useDataSource != null && useDataSource.fallbackDefault();
                }

                @Override
                public String getDataSourceId() {
                    return useDataSource == null ? null : useDataSource.value();
                }

                public String toString() {
                    return "Annotation Strategy(" + (useDataSource != null ? useDataSource : useDefaultDataSource) + ")";
                }

                @Override
                public String getDatabase() {
                    return useDataSource == null ? null : (StringUtils.isEmpty((Object)useDataSource.database()) ? null : useDataSource.database());
                }
            };
        }
        return null;
    }
}

