/*
 * Decompiled with CFR 0.152.
 */
package org.hswebframework.web.datasource.strategy;

import java.lang.reflect.Method;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.hswebframework.web.aop.MethodInterceptorContext;
import org.hswebframework.web.datasource.strategy.DataSourceSwitchStrategyMatcher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.ClassUtils;

public abstract class CachedDataSourceSwitchStrategyMatcher
implements DataSourceSwitchStrategyMatcher {
    private static final Logger log = LoggerFactory.getLogger(CachedDataSourceSwitchStrategyMatcher.class);
    static Map<CacheKey, DataSourceSwitchStrategyMatcher.Strategy> cache = new ConcurrentHashMap<CacheKey, DataSourceSwitchStrategyMatcher.Strategy>();

    public abstract DataSourceSwitchStrategyMatcher.Strategy createStrategyIfMatch(Class var1, Method var2);

    @Override
    public boolean match(Class target, Method method) {
        DataSourceSwitchStrategyMatcher.Strategy strategy = this.createStrategyIfMatch(target, method);
        if (null != strategy) {
            if (log.isDebugEnabled()) {
                log.debug("create data source switcher strategy:{} for method:{}", (Object)strategy, (Object)method);
            }
            CacheKey cacheKey = new CacheKey(target, method);
            cache.put(cacheKey, strategy);
            return true;
        }
        return false;
    }

    @Override
    public DataSourceSwitchStrategyMatcher.Strategy getStrategy(MethodInterceptorContext context) {
        Method method = context.getMethod();
        Class target = ClassUtils.getUserClass((Object)context.getTarget());
        return cache.get(new CacheKey(target, method));
    }

    public static class CacheKey {
        private Class<?> target;
        private Method method;

        public boolean equals(Object targetObject) {
            if (!(targetObject instanceof CacheKey)) {
                return false;
            }
            CacheKey targetCacheKey = (CacheKey)targetObject;
            return targetCacheKey.target.isAssignableFrom(this.target) && targetCacheKey.method.getName().equals(this.method.getName()) && targetCacheKey.method.getParameterCount() == this.method.getParameterCount();
        }

        public int hashCode() {
            int result = this.target != null ? this.target.getName().hashCode() : 0;
            result = 31 * result + (this.method != null ? this.method.getName().hashCode() : 0);
            return result;
        }

        public CacheKey(Class<?> target, Method method) {
            this.target = target;
            this.method = method;
        }
    }
}

