/*
 * Decompiled with CFR 0.152.
 */
package org.hswebframework.web.starter.jackson;

import com.fasterxml.jackson.core.JacksonException;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.BeanDescription;
import com.fasterxml.jackson.databind.DeserializationConfig;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.module.SimpleDeserializers;
import com.fasterxml.jackson.databind.module.SimpleModule;
import java.io.IOException;
import org.hswebframework.web.api.crud.entity.EntityFactory;
import org.hswebframework.web.dict.EnumDict;
import org.hswebframework.web.starter.jackson.CustomJackson2JsonDecoder;
import org.hswebframework.web.starter.jackson.CustomJackson2jsonEncoder;
import org.hswebframework.web.starter.jackson.CustomMappingJackson2HttpMessageConverter;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.jackson.JacksonAutoConfiguration;
import org.springframework.boot.web.codec.CodecCustomizer;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.annotation.Order;
import org.springframework.core.codec.Decoder;
import org.springframework.core.codec.Encoder;
import org.springframework.http.codec.CodecConfigurer;
import org.springframework.util.MimeType;

@Configuration(proxyBeanMethods=false)
@AutoConfigureAfter(value={JacksonAutoConfiguration.class})
public class CustomCodecsAutoConfiguration {

    @Configuration(proxyBeanMethods=false)
    @ConditionalOnClass(value={ObjectMapper.class})
    static class JacksonDecoderConfiguration {
        JacksonDecoderConfiguration() {
        }

        @Bean
        @Order(value=1)
        @ConditionalOnBean(value={ObjectMapper.class})
        CodecCustomizer jacksonDecoderCustomizer(final EntityFactory entityFactory, ObjectMapper objectMapper) {
            SimpleModule module = new SimpleModule();
            module.setDeserializers(new SimpleDeserializers(){

                public JsonDeserializer<?> findBeanDeserializer(JavaType type, DeserializationConfig config, BeanDescription beanDesc) throws JsonMappingException {
                    JsonDeserializer deserializer = super.findBeanDeserializer(type, config, beanDesc);
                    if (deserializer == null) {
                        final Class clazz = entityFactory.getInstanceType(type.getRawClass(), false);
                        if (clazz == null || clazz == type.getRawClass()) {
                            return null;
                        }
                        this.addDeserializer(type.getRawClass(), (JsonDeserializer)new JsonDeserializer<Object>(){

                            public Object deserialize(JsonParser p, DeserializationContext ctxt) throws IOException, JacksonException {
                                return p.readValueAs(clazz);
                            }
                        });
                    }
                    return super.findBeanDeserializer(type, config, beanDesc);
                }

                public JsonDeserializer<?> findEnumDeserializer(Class<?> type, DeserializationConfig config, BeanDescription beanDesc) {
                    EnumDict.EnumDictJSONDeserializer deser = null;
                    if (type.isEnum() && EnumDict.class.isAssignableFrom(type)) {
                        deser = new EnumDict.EnumDictJSONDeserializer(val -> EnumDict.find((Class)type, (Object)val).orElse(null));
                    }
                    return deser;
                }
            });
            objectMapper.registerModule((Module)module);
            return configurer -> {
                CodecConfigurer.DefaultCodecs defaults = configurer.defaultCodecs();
                defaults.jackson2JsonDecoder((Decoder)new CustomJackson2JsonDecoder(entityFactory, objectMapper, new MimeType[0]));
                defaults.jackson2JsonEncoder((Encoder)new CustomJackson2jsonEncoder(objectMapper, new MimeType[0]));
            };
        }

        @Bean
        CustomMappingJackson2HttpMessageConverter mappingJackson2HttpMessageConverter(EntityFactory entityFactory, ObjectMapper objectMapper) {
            return new CustomMappingJackson2HttpMessageConverter(objectMapper, entityFactory);
        }
    }
}

