/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.commons.configuration.attributes;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import org.infinispan.commons.configuration.attributes.Attribute;
import org.infinispan.commons.configuration.attributes.AttributeDefinition;
import org.infinispan.commons.configuration.attributes.AttributeListener;
import org.infinispan.commons.configuration.attributes.Matchable;
import org.infinispan.commons.configuration.attributes.Updatable;
import org.infinispan.commons.configuration.io.ConfigurationWriter;
import org.infinispan.commons.logging.Log;
import org.infinispan.commons.util.TypedProperties;

public class AttributeSet
implements AttributeListener<Object>,
Matchable<AttributeSet>,
Updatable<AttributeSet> {
    public static final AttributeSet EMPTY = new AttributeSet(null, "", null, new AttributeDefinition[0]).protect();
    private final Class<?> klass;
    private final String name;
    private final Map<String, Attribute<?>> attributes;
    private boolean protect;
    private final Map<String, RemovedAttribute> removed;

    public AttributeSet(Class<?> klass, AttributeDefinition<?> ... attributeDefinitions) {
        this(klass, klass.getSimpleName(), null, attributeDefinitions);
    }

    public AttributeSet(String name, AttributeDefinition<?> ... attributeDefinitions) {
        this(name, (AttributeSet)null, attributeDefinitions);
    }

    public AttributeSet(Class<?> klass, AttributeSet attributeSet, AttributeDefinition<?> ... attributeDefinitions) {
        this(klass, klass.getSimpleName(), attributeSet, attributeDefinitions);
    }

    public AttributeSet(String name, AttributeSet attributeSet, AttributeDefinition<?>[] attributeDefinitions) {
        this(null, name, attributeSet, attributeDefinitions);
    }

    public AttributeSet(Class<?> klass, Enum<?> name, AttributeDefinition<?> ... attributeDefinitions) {
        this(klass, name.name(), null, attributeDefinitions);
    }

    public AttributeSet(Class<?> klass, String name, AttributeSet attributeSet, AttributeDefinition<?>[] attributeDefinitions) {
        this(klass, name, attributeSet, attributeDefinitions, null);
    }

    public AttributeSet(Class<?> klass, String name, AttributeSet attributeSet, AttributeDefinition<?>[] attributeDefinitions, RemovedAttribute[] removedAttributes) {
        this.klass = klass;
        this.name = name;
        if (attributeSet != null) {
            this.attributes = new LinkedHashMap(attributeDefinitions.length + attributeSet.attributes.size());
            for (Attribute attribute : attributeSet.attributes.values()) {
                this.attributes.put(attribute.name(), attribute.getAttributeDefinition().toAttribute());
            }
        } else {
            this.attributes = new LinkedHashMap(attributeDefinitions.length);
        }
        for (AttributeDefinition<?> def : attributeDefinitions) {
            if (this.attributes.containsKey(def.name())) {
                throw Log.CONFIG.attributeSetDuplicateAttribute(def.name(), name);
            }
            Attribute<Object> attribute = def.toAttribute();
            if (!attribute.isImmutable()) {
                attribute.addListener(this);
            }
            this.attributes.put(def.name(), attribute);
        }
        if (removedAttributes == null) {
            this.removed = Collections.emptyMap();
        } else {
            this.removed = new HashMap<String, RemovedAttribute>(removedAttributes.length);
            for (RemovedAttribute i : removedAttributes) {
                this.removed.put(i.name, i);
            }
        }
    }

    public Class<?> getKlass() {
        return this.klass;
    }

    public String getName() {
        return this.name;
    }

    public boolean contains(String name) {
        return this.attributes.containsKey(name);
    }

    public <T> boolean contains(AttributeDefinition<T> def) {
        return this.contains(def.name());
    }

    public <T> Attribute<T> attribute(String name) {
        return this.attributes.get(name);
    }

    public <T> Attribute<T> attribute(Enum<?> name) {
        return this.attribute(name.toString());
    }

    public <T> Attribute<T> attribute(AttributeDefinition<T> def) {
        Attribute<T> attribute = this.attribute(def.name());
        if (attribute != null) {
            return attribute;
        }
        throw Log.CONFIG.noSuchAttribute(def.name(), this.name);
    }

    public void read(AttributeSet other) {
        for (Attribute<?> attribute : this.attributes.values()) {
            Attribute a = other.attribute(attribute.name());
            if (!a.isModified()) continue;
            attribute.read(a);
        }
    }

    public AttributeSet protect() {
        AttributeDefinition[] attrDefs = new AttributeDefinition[this.attributes.size()];
        int i = 0;
        for (Attribute<?> attribute : this.attributes.values()) {
            attrDefs[i++] = attribute.getAttributeDefinition();
        }
        AttributeSet protectedSet = new AttributeSet(this.klass, this.name, null, attrDefs);
        for (Attribute<?> attribute : protectedSet.attributes.values()) {
            Attribute<?> localAttr = this.attributes.get(attribute.name());
            attribute.read(localAttr);
            attribute.protect();
        }
        protectedSet.protect = true;
        return protectedSet;
    }

    public boolean isModified() {
        for (Attribute<?> attribute : this.attributes.values()) {
            if (!attribute.isModified()) continue;
            return true;
        }
        return false;
    }

    public boolean isProtected() {
        return this.protect;
    }

    public void write(ConfigurationWriter writer, AttributeDefinition<?> def) {
        this.write(writer, def, def.name());
    }

    public void write(ConfigurationWriter writer, AttributeDefinition<?> def, Enum<?> name) {
        this.write(writer, def, name.toString());
    }

    public void write(ConfigurationWriter writer, AttributeDefinition<?> def, String name) {
        Attribute<?> attribute = this.attribute(def);
        attribute.write(writer, name);
    }

    public void write(ConfigurationWriter writer, String name) {
        if (this.isModified()) {
            writer.writeStartElement(name);
            this.write(writer);
            writer.writeEndElement();
        }
    }

    public void write(ConfigurationWriter writer, Enum<?> name) {
        this.write(writer, name.toString());
    }

    public void write(ConfigurationWriter writer, String persistentName, AttributeDefinition<?> ... defs) {
        if (Arrays.stream(defs).anyMatch(def -> this.attribute((AttributeDefinition)def).isModified())) {
            writer.writeStartElement(persistentName);
            for (AttributeDefinition<?> def2 : defs) {
                Attribute<?> attr = this.attribute(def2);
                attr.write(writer, attr.getAttributeDefinition().name());
            }
            writer.writeEndElement();
        }
    }

    public void write(ConfigurationWriter writer) {
        for (Attribute<?> attr : this.attributes.values()) {
            if (!attr.isPersistent()) continue;
            attr.write(writer, attr.getAttributeDefinition().name());
        }
    }

    public void validate() {
        this.attributes.values().forEach(Attribute::validate);
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.attributes == null ? 0 : this.attributes.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        AttributeSet other = (AttributeSet)obj;
        return !(this.attributes == null ? other.attributes != null : !this.attributes.equals(other.attributes));
    }

    @Override
    public boolean matches(AttributeSet other) {
        if (other.attributes.size() != this.attributes.size()) {
            return false;
        }
        for (Map.Entry<String, Attribute<?>> e : this.attributes.entrySet()) {
            String key = e.getKey();
            Attribute<?> value = e.getValue();
            if (!(value == null ? !other.attributes.containsKey(key) || other.attributes.get(key) != null : !value.matches(other.attributes.get(key)))) continue;
            return false;
        }
        return true;
    }

    @Override
    public void update(String parentName, AttributeSet other) {
        for (Map.Entry<String, Attribute<?>> e : this.attributes.entrySet()) {
            e.getValue().update(parentName, other.attribute(e.getKey()));
        }
    }

    @Override
    public void validateUpdate(String parentName, AttributeSet other) {
        IllegalArgumentException iae = new IllegalArgumentException();
        for (Map.Entry<String, Attribute<?>> e : this.attributes.entrySet()) {
            try {
                e.getValue().validateUpdate(parentName, other.attribute(e.getKey()));
            }
            catch (Throwable t) {
                iae.addSuppressed(t);
            }
        }
        if (iae.getSuppressed().length > 0) {
            throw iae;
        }
    }

    public String toString() {
        return this.toString(this.name);
    }

    public String toString(String name) {
        StringBuilder sb = new StringBuilder();
        if (name != null) {
            sb.append(name);
            sb.append(" = ");
        }
        sb.append("[");
        boolean comma = false;
        for (Attribute<?> value : this.attributes.values()) {
            if (comma) {
                sb.append(", ");
            } else {
                comma = true;
            }
            sb.append(value.toString());
        }
        sb.append("]");
        return sb.toString();
    }

    public AttributeSet checkProtection() {
        if (!this.protect) {
            throw Log.CONFIG.unprotectedAttributeSet(this.name);
        }
        return this;
    }

    public void reset() {
        if (this.protect) {
            throw Log.CONFIG.protectedAttributeSet(this.name);
        }
        for (Attribute<?> attribute : this.attributes.values()) {
            attribute.reset();
        }
    }

    @Override
    public void attributeChanged(Attribute<Object> attribute, Object oldValue) {
    }

    public Collection<Attribute<?>> attributes() {
        return this.attributes.values();
    }

    public boolean isEmpty() {
        return this.attributes.entrySet().stream().allMatch(attrs -> {
            Attribute attr = (Attribute)attrs.getValue();
            return attr.isNull() || !attr.isModified();
        });
    }

    public TypedProperties fromProperties(TypedProperties properties, String prefix) {
        for (Attribute<?> attr : this.attributes.values()) {
            String name = prefix + attr.name();
            if (!properties.containsKey(name)) continue;
            attr.fromString(properties.getProperty(name, true));
        }
        return properties;
    }

    public boolean isRemoved(String name, int major, int minor) {
        RemovedAttribute r = this.removed.get(name);
        return r != null && (major < r.major || major == r.major && minor < r.minor);
    }

    public static final class RemovedAttribute {
        final String name;
        final int major;
        final int minor;

        public RemovedAttribute(Enum<?> name, int major, int minor) {
            this(name.toString(), major, minor);
        }

        public RemovedAttribute(String name, int major, int minor) {
            this.name = name;
            this.major = major;
            this.minor = minor;
        }
    }
}

