/*
 * Decompiled with CFR 0.152.
 */
package org.jeecg.modules.airag.flow.vo.api;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import org.jeecg.common.util.oConvertUtils;
import org.jeecg.modules.airag.flow.entity.AiragFlow;
import org.jeecg.modules.airag.flow.vo.flow.config.FlowNode;
import org.jeecg.modules.airag.flow.vo.flow.config.FlowNodeConfig;
import org.springframework.util.CollectionUtils;

public class SubFlowResult {
    private String id;
    private String name;
    private String descr;
    private String status;
    private List<FlowNodeConfig.NodeParam> inputParams;
    private List<FlowNodeConfig.NodeParam> outputParams;

    public SubFlowResult(AiragFlow flow) {
        this.id = flow.getId();
        this.name = flow.getName();
        this.descr = flow.getDescr();
        this.status = flow.getStatus();
        this.inputParams = new ArrayList<FlowNodeConfig.NodeParam>();
        this.outputParams = new ArrayList<FlowNodeConfig.NodeParam>();
        this.initParams(flow);
    }

    private void initParams(AiragFlow flow) {
        JSONObject jSONObject;
        try {
            jSONObject = JSONObject.parseObject((String)flow.getDesign());
        }
        catch (Exception exception) {
            return;
        }
        if (null == jSONObject || !jSONObject.containsKey((Object)"nodes")) {
            return;
        }
        JSONArray jSONArray = jSONObject.getJSONArray("nodes");
        if (CollectionUtils.isEmpty((Collection)jSONArray)) {
            return;
        }
        HashMap<String, FlowNodeConfig.NodeParam> hashMap = new HashMap<String, FlowNodeConfig.NodeParam>();
        for (Object e2 : jSONArray) {
            FlowNode flowNode = (FlowNode)((JSONObject)e2).toJavaObject(FlowNode.class);
            FlowNodeConfig flowNodeConfig = flowNode.getProperties();
            if ("start".equals(flowNode.getType())) {
                this.inputParams = flowNodeConfig.getInputParams();
                continue;
            }
            if (!"end".equals(flowNode.getType())) continue;
            boolean bl = false;
            if (oConvertUtils.isObjectNotEmpty(flowNodeConfig.getOptions())) {
                bl = (Boolean)flowNodeConfig.getOptions().get("outputText");
            }
            if (bl) {
                FlowNodeConfig.NodeParam nodeParam2 = new FlowNodeConfig.NodeParam();
                nodeParam2.setName("outputText");
                nodeParam2.setField("outputText");
                hashMap.put(nodeParam2.getField(), nodeParam2);
                continue;
            }
            flowNodeConfig.getOutputParams().forEach(nodeParam -> hashMap.put(nodeParam.getName(), (FlowNodeConfig.NodeParam)nodeParam));
        }
        this.outputParams = new ArrayList(hashMap.values());
    }

    public String getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public String getDescr() {
        return this.descr;
    }

    public String getStatus() {
        return this.status;
    }

    public List<FlowNodeConfig.NodeParam> getInputParams() {
        return this.inputParams;
    }

    public List<FlowNodeConfig.NodeParam> getOutputParams() {
        return this.outputParams;
    }

    public void setId(String id) {
        this.id = id;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setDescr(String descr) {
        this.descr = descr;
    }

    public void setStatus(String status) {
        this.status = status;
    }

    public void setInputParams(List<FlowNodeConfig.NodeParam> inputParams) {
        this.inputParams = inputParams;
    }

    public void setOutputParams(List<FlowNodeConfig.NodeParam> outputParams) {
        this.outputParams = outputParams;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof SubFlowResult)) {
            return false;
        }
        SubFlowResult subFlowResult = (SubFlowResult)o;
        if (!subFlowResult.canEqual(this)) {
            return false;
        }
        String string = this.getId();
        String string2 = subFlowResult.getId();
        if (string == null ? string2 != null : !string.equals(string2)) {
            return false;
        }
        String string3 = this.getName();
        String string4 = subFlowResult.getName();
        if (string3 == null ? string4 != null : !string3.equals(string4)) {
            return false;
        }
        String string5 = this.getDescr();
        String string6 = subFlowResult.getDescr();
        if (string5 == null ? string6 != null : !string5.equals(string6)) {
            return false;
        }
        String string7 = this.getStatus();
        String string8 = subFlowResult.getStatus();
        if (string7 == null ? string8 != null : !string7.equals(string8)) {
            return false;
        }
        List<FlowNodeConfig.NodeParam> list = this.getInputParams();
        List<FlowNodeConfig.NodeParam> list2 = subFlowResult.getInputParams();
        if (list == null ? list2 != null : !((Object)list).equals(list2)) {
            return false;
        }
        List<FlowNodeConfig.NodeParam> list3 = this.getOutputParams();
        List<FlowNodeConfig.NodeParam> list4 = subFlowResult.getOutputParams();
        return !(list3 == null ? list4 != null : !((Object)list3).equals(list4));
    }

    protected boolean canEqual(Object other) {
        return other instanceof SubFlowResult;
    }

    public int hashCode() {
        int n = 59;
        int n2 = 1;
        String string = this.getId();
        n2 = n2 * 59 + (string == null ? 43 : string.hashCode());
        String string2 = this.getName();
        n2 = n2 * 59 + (string2 == null ? 43 : string2.hashCode());
        String string3 = this.getDescr();
        n2 = n2 * 59 + (string3 == null ? 43 : string3.hashCode());
        String string4 = this.getStatus();
        n2 = n2 * 59 + (string4 == null ? 43 : string4.hashCode());
        List<FlowNodeConfig.NodeParam> list = this.getInputParams();
        n2 = n2 * 59 + (list == null ? 43 : ((Object)list).hashCode());
        List<FlowNodeConfig.NodeParam> list2 = this.getOutputParams();
        n2 = n2 * 59 + (list2 == null ? 43 : ((Object)list2).hashCode());
        return n2;
    }

    public String toString() {
        return "SubFlowResult(id=" + this.getId() + ", name=" + this.getName() + ", descr=" + this.getDescr() + ", status=" + this.getStatus() + ", inputParams=" + this.getInputParams() + ", outputParams=" + this.getOutputParams() + ")";
    }
}

