/*
 * Decompiled with CFR 0.152.
 */
package org.jetlinks.supports.cache;

import java.io.File;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.concurrent.atomic.AtomicLongFieldUpdater;
import java.util.concurrent.locks.ReentrantLock;
import javax.annotation.Nonnull;
import org.h2.mvstore.Cursor;
import org.h2.mvstore.MVMap;
import org.h2.mvstore.MVStore;
import org.h2.mvstore.type.DataType;
import org.jetlinks.core.cache.FileQueue;
import org.jetlinks.core.codec.Codec;
import org.jetlinks.core.config.ConfigKey;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.Assert;

class MVStoreQueue<T>
implements FileQueue<T> {
    private static final Logger log = LoggerFactory.getLogger(MVStoreQueue.class);
    private static final AtomicLongFieldUpdater<MVStoreQueue> INDEX = AtomicLongFieldUpdater.newUpdater(MVStoreQueue.class, "index");
    private MVStore store;
    private MVMap<Long, T> mvMap;
    private volatile long index;
    private final String name;
    private final Path storageFile;
    private final Map<String, Object> options;
    private final ReentrantLock pollLock;
    private final ReentrantLock writeLock;

    MVStoreQueue(Path filePath, String name, Map<String, Object> options) {
        block5: {
            this.index = 0L;
            this.pollLock = new ReentrantLock();
            this.writeLock = new ReentrantLock();
            Files.createDirectories(filePath, new FileAttribute[0]);
            this.name = name;
            this.storageFile = filePath.resolve(name);
            this.options = options;
            try {
                this.open();
            }
            catch (Throwable err) {
                File back = filePath.resolve(name + "_" + System.currentTimeMillis() + ".crash").toFile();
                if (this.storageFile.toFile().renameTo(back)) {
                    this.open();
                    log.warn("open queue file error,rename to {}", (Object)back, (Object)err);
                    break block5;
                }
                throw err;
            }
        }
    }

    protected void open() {
        try {
            if (this.store != null && !this.store.isClosed()) {
                this.store.close();
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        String path = this.storageFile.toUri().getScheme().equals("jimfs") ? this.storageFile.toUri().toString() : this.storageFile.toString();
        MVStore.Builder builder = new MVStore.Builder().fileName(path).cacheSize(16).autoCommitBufferSize(32768).compress();
        this.store = builder.open();
        Object type = this.options.get("valueType");
        MVMap.Builder mapBuilder = new MVMap.Builder();
        if (type instanceof DataType) {
            mapBuilder.valueType((DataType)type);
        }
        this.mvMap = this.store.openMap("queue", (MVMap.MapBuilder)mapBuilder);
        if (!this.mvMap.isEmpty()) {
            INDEX.set(this, (Long)this.mvMap.lastKey());
        }
    }

    public void flush() {
        if (this.store.isClosed()) {
            return;
        }
        this.store.commit();
        this.store.compactMoveChunks();
    }

    public T removeFirst() {
        this.checkClose();
        this.pollLock.lock();
        try {
            Long key = (Long)this.mvMap.firstKey();
            Object object = key == null ? null : this.mvMap.remove((Object)key);
            return (T)object;
        }
        finally {
            this.pollLock.unlock();
        }
    }

    public T removeLast() {
        this.checkClose();
        this.pollLock.lock();
        try {
            Long key = (Long)this.mvMap.lastKey();
            Object object = key == null ? null : this.mvMap.remove((Object)key);
            return (T)object;
        }
        finally {
            this.pollLock.unlock();
        }
    }

    public synchronized void close() {
        if (this.store.isClosed()) {
            return;
        }
        this.store.compactMoveChunks();
        this.store.sync();
        this.store.close();
    }

    private void checkClose() {
        if (this.store.isClosed()) {
            throw new IllegalStateException("file queue " + this.name + " is closed");
        }
    }

    public int size() {
        this.checkClose();
        return this.mvMap.size();
    }

    public boolean isEmpty() {
        this.checkClose();
        return this.mvMap.isEmpty();
    }

    public boolean contains(Object o) {
        this.checkClose();
        return this.mvMap.containsValue(o);
    }

    @Nonnull
    public Iterator<T> iterator() {
        this.checkClose();
        final Cursor cursor = this.mvMap.cursor(null, null, false);
        return new Iterator<T>(){

            @Override
            public boolean hasNext() {
                return cursor.hasNext();
            }

            @Override
            public T next() {
                return cursor.getValue();
            }

            @Override
            public void remove() {
                MVStoreQueue.this.mvMap.remove(cursor.getKey());
            }
        };
    }

    @Nonnull
    public Object[] toArray() {
        return this.toArray(new Object[0]);
    }

    @Nonnull
    public <T1> T1[] toArray(@Nonnull T1[] a) {
        this.checkClose();
        return this.stream().toArray(i -> a);
    }

    public boolean add(T t) {
        this.checkClose();
        if (null == t) {
            return false;
        }
        this.writeLock.lock();
        try {
            this.doAdd(t);
        }
        finally {
            this.writeLock.unlock();
        }
        return true;
    }

    private void doAdd(T value) {
        Object val = value;
        while ((val = this.mvMap.putIfAbsent((Object)INDEX.incrementAndGet(this), val)) != null) {
        }
    }

    public boolean remove(Object o) {
        throw new UnsupportedOperationException("remove unsupported");
    }

    public boolean containsAll(Collection<?> c) {
        this.checkClose();
        return this.mvMap.values().containsAll(c);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean addAll(Collection<? extends T> c) {
        this.checkClose();
        this.writeLock.lock();
        try {
            for (T t : c) {
                this.doAdd(t);
            }
        }
        finally {
            this.writeLock.unlock();
        }
        return true;
    }

    public boolean removeAll(Collection<?> c) {
        throw new UnsupportedOperationException("removeAll unsupported");
    }

    public boolean retainAll(Collection<?> c) {
        throw new UnsupportedOperationException("retainAll unsupported");
    }

    public void clear() {
        if (this.mvMap.isClosed()) {
            return;
        }
        this.mvMap.clear();
        INDEX.set(this, 0L);
    }

    public boolean offer(T t) {
        this.checkClose();
        return this.add(t);
    }

    public T remove() {
        this.checkClose();
        T data = this.poll();
        if (data == null) {
            throw new NoSuchElementException("No such element in file " + this.storageFile);
        }
        return data;
    }

    public T poll() {
        Object removed;
        if (this.mvMap.isClosed()) {
            return null;
        }
        try {
            this.pollLock.lock();
            Long key = (Long)this.mvMap.firstKey();
            removed = key == null ? null : this.mvMap.remove((Object)key);
        }
        finally {
            this.pollLock.unlock();
        }
        return (T)removed;
    }

    public T element() {
        if (this.mvMap.isClosed()) {
            return null;
        }
        T data = this.peek();
        if (data == null) {
            throw new NoSuchElementException("No such element in file " + this.storageFile);
        }
        return data;
    }

    public T peek() {
        this.checkClose();
        return (T)this.mvMap.get(this.mvMap.firstKey());
    }

    static class Builder<T>
    implements FileQueue.Builder<T> {
        private String name;
        private Codec<T> codec;
        private Path path;
        private Map<String, Object> options = new HashMap<String, Object>();

        Builder() {
        }

        public FileQueue.Builder<T> name(String name) {
            this.name = name;
            return this;
        }

        public FileQueue.Builder<T> codec(Codec<T> codec) {
            this.codec = codec;
            return this;
        }

        public FileQueue.Builder<T> path(Path path) {
            this.path = path;
            return this;
        }

        public FileQueue.Builder<T> options(Map<String, Object> options) {
            this.options.putAll(options);
            return this;
        }

        public FileQueue.Builder<T> option(String key, Object value) {
            this.options.put(key, value);
            return this;
        }

        public <V> FileQueue.Builder<T> option(ConfigKey<V> key, V value) {
            this.options.put(key.getName(), value);
            return this;
        }

        public FileQueue<T> build() {
            Assert.hasText((String)this.name, (String)"name must not be empty");
            Assert.notNull((Object)this.path, (String)"path must not be null");
            Assert.notNull((Object)this.path, (String)"codec must not be null");
            return new MVStoreQueue(this.path, this.name, this.options);
        }
    }
}

