/*
 * Decompiled with CFR 0.152.
 */
package org.jetlinks.supports.cluster;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.RemovalCause;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import io.netty.buffer.ByteBufInputStream;
import io.netty.buffer.ByteBufOutputStream;
import io.scalecube.services.annotations.ServiceMethod;
import java.io.InputStream;
import java.io.ObjectInput;
import java.io.ObjectInputStream;
import java.io.ObjectOutput;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.time.Duration;
import java.util.Collection;
import java.util.Map;
import java.util.Queue;
import java.util.function.Function;
import org.jetlinks.core.device.DeviceStateInfo;
import org.jetlinks.core.device.session.DeviceSessionManager;
import org.jetlinks.core.enums.ErrorCode;
import org.jetlinks.core.message.BroadcastMessage;
import org.jetlinks.core.message.CommonDeviceMessageReply;
import org.jetlinks.core.message.DeviceMessage;
import org.jetlinks.core.message.DeviceMessageReply;
import org.jetlinks.core.message.Headers;
import org.jetlinks.core.message.Message;
import org.jetlinks.core.message.MessageType;
import org.jetlinks.core.message.RepayableDeviceMessage;
import org.jetlinks.core.rpc.RpcManager;
import org.jetlinks.core.rpc.RpcService;
import org.jetlinks.core.trace.TraceHolder;
import org.jetlinks.core.utils.Reactors;
import org.jetlinks.core.utils.SerializeUtils;
import org.jetlinks.supports.cluster.AbstractDeviceOperationBroker;
import org.reactivestreams.Publisher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import reactor.core.Disposable;
import reactor.core.Disposables;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;
import reactor.core.publisher.Sinks;
import reactor.util.concurrent.Queues;

public class RpcDeviceOperationBroker
extends AbstractDeviceOperationBroker {
    private static final Logger log = LoggerFactory.getLogger(RpcDeviceOperationBroker.class);
    private final RpcManager rpcManager;
    private final DeviceSessionManager sessionManager;
    private final Sinks.Many<Message> sendToDevice = Sinks.unsafe().many().unicast().onBackpressureBuffer((Queue)Queues.unboundedMultiproducer().get());
    private final Map<String, RepayableDeviceMessage<?>> awaits = CacheBuilder.newBuilder().expireAfterWrite(Duration.ofMinutes(5L)).removalListener(notify -> {
        if (notify.getCause() == RemovalCause.EXPIRED) {
            try {
                log.debug("discard await reply message[{}] message,{}", notify.getKey(), notify.getValue());
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }).build().asMap();
    static MessageType[] types = MessageType.values();

    public RpcDeviceOperationBroker(RpcManager rpcManager, DeviceSessionManager sessionManager) {
        this.rpcManager = rpcManager;
        this.sessionManager = sessionManager;
        rpcManager.registerService((Object)new ServiceImpl());
    }

    @Override
    public Flux<DeviceStateInfo> getDeviceState(String deviceGatewayServerId, Collection<String> deviceIdList) {
        return Flux.fromIterable(deviceIdList).flatMap(id -> this.sessionManager.checkAlive(id, false).map(alive -> new DeviceStateInfo(id, alive != false ? (byte)1 : (byte)-1)));
    }

    @Override
    public Disposable handleGetDeviceState(String serverId, Function<Publisher<String>, Flux<DeviceStateInfo>> stateMapper) {
        return Disposables.disposed();
    }

    @Override
    public Mono<Integer> send(String deviceGatewayServerId, Publisher<? extends Message> message) {
        if (this.rpcManager.currentServerId().equals(deviceGatewayServerId)) {
            return Flux.from(message).flatMap(this::handleSendToDevice).then(Reactors.ALWAYS_ONE);
        }
        return Flux.from(message).flatMap(msg -> {
            msg.addHeader(Headers.sendFrom, (Object)this.rpcManager.currentServerId());
            if (msg instanceof RepayableDeviceMessage) {
                String key = this.getAwaitReplyKey((DeviceMessage)((RepayableDeviceMessage)msg));
                this.awaits.putIfAbsent(key, (RepayableDeviceMessage)msg);
            }
            return this.rpcManager.getService(deviceGatewayServerId, Service.class).flatMap(service -> service.send(this.encode((Message)msg)).thenReturn((Object)1)).defaultIfEmpty((Object)0);
        }).reduce((Object)0, Integer::sum);
    }

    private Mono<Void> handleSendToDevice(Message message) {
        if (message instanceof RepayableDeviceMessage) {
            RepayableDeviceMessage msg = (RepayableDeviceMessage)message;
            this.awaits.put(this.getAwaitReplyKey((DeviceMessage)msg), msg);
        }
        return this.doSendToDevice(message);
    }

    private Mono<Void> doSendToDevice(Message message) {
        return TraceHolder.writeContextTo((Object)message, Message::addHeader).flatMap(msg -> {
            if (this.sendToDevice.currentSubscriberCount() == 0) {
                log.warn("no handler for message {}", msg);
                return this.doReply(this.createReply((Message)msg).error(ErrorCode.SYSTEM_ERROR));
            }
            try {
                this.sendToDevice.emitNext(msg, Reactors.emitFailureHandler());
            }
            catch (Throwable err) {
                return this.doReply(this.createReply((Message)msg).error(err));
            }
            return Mono.empty();
        });
    }

    private DeviceMessageReply createReply(Message message) {
        if (message instanceof RepayableDeviceMessage) {
            return ((RepayableDeviceMessage)message).newReply();
        }
        if (message instanceof DeviceMessage) {
            return new CommonDeviceMessageReply().deviceId(((DeviceMessage)message).getDeviceId()).messageId(message.getMessageId());
        }
        return new CommonDeviceMessageReply().messageId(message.getMessageId());
    }

    @Override
    public Mono<Integer> send(Publisher<? extends BroadcastMessage> message) {
        return Reactors.ALWAYS_ZERO;
    }

    @Override
    public Flux<Message> handleSendToDeviceMessage(String serverId) {
        return this.sendToDevice.asFlux();
    }

    @Override
    protected Mono<Void> doReply(DeviceMessageReply reply) {
        RepayableDeviceMessage<?> msg = this.awaits.remove(this.getAwaitReplyKey((DeviceMessage)reply));
        String serviceId = null;
        if (null != msg) {
            serviceId = msg.getHeader(Headers.sendFrom).orElse(null);
        }
        Flux serviceFlux = serviceId != null ? this.rpcManager.getService(serviceId, Service.class).flux() : this.rpcManager.getServices(Service.class).map(RpcService::service);
        return serviceFlux.flatMap(service -> service.reply(this.encode((Message)reply))).then();
    }

    protected ObjectInput createInput(ByteBuf input) {
        return new ObjectInputStream((InputStream)new ByteBufInputStream(input, true));
    }

    protected ObjectOutput createOutput(ByteBuf output) {
        return new ObjectOutputStream((OutputStream)new ByteBufOutputStream(output));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Message decode(ByteBuf buf) {
        try (ObjectInput input = this.createInput(buf);){
            MessageType type = types[input.readByte()];
            DeviceMessage msg = type.forDevice();
            if (msg != null) {
                msg.readExternal(input);
                DeviceMessage deviceMessage = msg;
                return deviceMessage;
            }
            Message message = (Message)SerializeUtils.readObject((ObjectInput)input);
            return message;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private ByteBuf encode(Message message) {
        ByteBuf buf = ByteBufAllocator.DEFAULT.buffer();
        try (ObjectOutput output = this.createOutput(buf);){
            output.writeByte(message.getMessageType().ordinal());
            if (message.getMessageType().iSupportDevice()) {
                message.writeExternal(output);
            } else {
                SerializeUtils.writeObject((Object)message, (ObjectOutput)output);
            }
            ByteBuf byteBuf = buf;
            return byteBuf;
        }
    }

    private class ServiceImpl
    implements Service {
        private ServiceImpl() {
        }

        @Override
        public Mono<Void> send(ByteBuf payload) {
            return RpcDeviceOperationBroker.this.doSendToDevice(RpcDeviceOperationBroker.this.decode(payload));
        }

        @Override
        public Mono<Void> reply(ByteBuf buf) {
            Message msg = RpcDeviceOperationBroker.this.decode(buf);
            if (msg instanceof DeviceMessageReply) {
                RpcDeviceOperationBroker.this.handleReply((DeviceMessageReply)msg);
            }
            return Mono.empty();
        }
    }

    @io.scalecube.services.annotations.Service
    public static interface Service {
        @ServiceMethod
        public Mono<Void> send(ByteBuf var1);

        @ServiceMethod
        public Mono<Void> reply(ByteBuf var1);
    }
}

