/*
 * Decompiled with CFR 0.152.
 */
package org.jetlinks.supports.config;

import com.google.common.collect.Maps;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.concurrent.atomic.AtomicIntegerFieldUpdater;
import java.util.concurrent.atomic.AtomicReferenceFieldUpdater;
import org.jctools.maps.NonBlockingHashMap;
import org.jetlinks.core.Value;
import org.jetlinks.core.Values;
import org.jetlinks.core.cluster.ClusterCache;
import org.jetlinks.core.config.ConfigStorage;
import org.jetlinks.core.event.EventBus;
import org.jetlinks.core.utils.Reactors;
import org.jetlinks.supports.config.CacheNotify;
import org.springframework.util.CollectionUtils;
import reactor.core.Disposable;
import reactor.core.publisher.Mono;
import reactor.core.publisher.Sinks;

public class LocalCacheClusterConfigStorage
implements ConfigStorage {
    private static final AtomicReferenceFieldUpdater<Cache, Mono> CACHE_REF = AtomicReferenceFieldUpdater.newUpdater(Cache.class, Mono.class, "ref");
    private static final AtomicIntegerFieldUpdater<Cache> CACHE_VERSION = AtomicIntegerFieldUpdater.newUpdater(Cache.class, "version");
    private static final AtomicReferenceFieldUpdater<Cache, Disposable> CACHE_LOADER = AtomicReferenceFieldUpdater.newUpdater(Cache.class, Disposable.class, "loader");
    private final Map<String, Cache> caches = new NonBlockingHashMap();
    private final String id;
    private final EventBus eventBus;
    private final ClusterCache<String, Object> clusterCache;
    private long expires;
    private final Runnable doOnClear;
    public static final Value NULL = Value.simple(null);

    private Cache createCache(String key) {
        return new Cache(key);
    }

    private Cache getOrCreateCache(String key) {
        return this.caches.computeIfAbsent(key, this::createCache);
    }

    public Mono<Value> getConfig(String key) {
        return this.getOrCreateCache(key).getRef();
    }

    Values wrapCache(Collection<String> keys) {
        return Values.of((Map)Maps.filterEntries((Map)Maps.transformValues(this.caches, Cache::getCachedValue), e -> e.getValue() != null && keys.contains(e.getKey())));
    }

    public Mono<Values> getConfigs(Collection<String> keys) {
        int hits = 0;
        for (String key : keys) {
            Cache local = this.getOrCreateCache(key);
            Value cached = local.getCached();
            if (cached == null) continue;
            ++hits;
        }
        if (hits == keys.size()) {
            return Mono.just((Object)this.wrapCache(keys));
        }
        Values wrap = this.wrapCache(keys);
        HashSet<String> needLoadKeys = new HashSet<String>(keys);
        needLoadKeys.removeAll(wrap.getAllValues().keySet());
        if (needLoadKeys.isEmpty()) {
            return Mono.just((Object)wrap);
        }
        HashMap versions = Maps.newHashMapWithExpectedSize((int)this.caches.size());
        for (Map.Entry<String, Cache> entry2 : this.caches.entrySet()) {
            versions.put(entry2.getKey(), entry2.getValue().version);
        }
        return this.clusterCache.get(needLoadKeys).reduce(new HashMap(), (map, entry) -> {
            String key = (String)entry.getKey();
            Object value = entry.getValue();
            Cache cache = this.getOrCreateCache(key);
            int version = versions.getOrDefault(key, cache.version);
            this.updateValue(cache, version, value);
            if (null != value) {
                map.put(key, cache);
            }
            return map;
        }).defaultIfEmpty(Collections.emptyMap()).doOnNext(map -> {
            needLoadKeys.removeAll(map.keySet());
            if (needLoadKeys.size() > 0) {
                for (String needLoadKey : needLoadKeys) {
                    Cache cache = this.getOrCreateCache(needLoadKey);
                    int version = versions.getOrDefault(needLoadKey, cache.version);
                    this.updateValue(cache, version, null);
                }
            }
        }).thenReturn((Object)wrap);
    }

    private void updateValue(Cache cache, int version, Object value) {
        if (cache != null && cache.version == version) {
            cache.setValue(value);
        }
    }

    public Mono<Boolean> setConfigs(Map<String, Object> values) {
        if (CollectionUtils.isEmpty(values)) {
            return Reactors.ALWAYS_TRUE;
        }
        values.forEach((key, value) -> this.getOrCreateCache((String)key).setValue(value));
        return this.clusterCache.putAll(values).then(this.notify(CacheNotify.expires(this.id, values.keySet()))).thenReturn((Object)true);
    }

    public Mono<Boolean> setConfig(String key, Object value) {
        if (key == null) {
            return Reactors.ALWAYS_FALSE;
        }
        if (value == null) {
            return this.remove(key);
        }
        this.getOrCreateCache(key).setValue(value);
        return this.clusterCache.put((Object)key, value).then(this.notifyRemoveKey(key)).thenReturn((Object)true);
    }

    public Mono<Boolean> remove(String key) {
        return this.clusterCache.remove((Object)key).then(this.notifyRemoveKey(key)).thenReturn((Object)true);
    }

    public Mono<Value> getAndRemove(String key) {
        return this.clusterCache.getAndRemove((Object)key).flatMap(res -> this.notify(CacheNotify.expires(this.id, Collections.singleton(key))).thenReturn(res)).map(Value::simple);
    }

    public Mono<Boolean> remove(Collection<String> key) {
        return this.clusterCache.remove(key).then(this.notify(CacheNotify.expires(this.id, key))).thenReturn((Object)true);
    }

    public Mono<Boolean> clear() {
        return this.clusterCache.clear().then(this.notify(CacheNotify.clear(this.id))).thenReturn((Object)true);
    }

    void clearLocalCache(CacheNotify notify) {
        if (CollectionUtils.isEmpty(notify.getKeys())) {
            this.caches.clear();
        } else {
            notify.getKeys().forEach(this.caches::remove);
        }
        if (notify.isClear() && this.doOnClear != null) {
            this.doOnClear.run();
        }
    }

    Mono<Void> notify(CacheNotify notify) {
        this.clearLocalCache(notify);
        return this.eventBus.publish("/_sys/cluster_cache", (Object)notify).then();
    }

    Mono<Void> notifyRemoveKey(String key) {
        return this.notify(CacheNotify.expires(this.id, Collections.singleton(key)));
    }

    public Mono<Void> refresh() {
        return this.notify(CacheNotify.expiresAll(this.id));
    }

    public Mono<Void> refresh(Collection<String> keys) {
        return this.notify(CacheNotify.expires(this.id, keys));
    }

    public LocalCacheClusterConfigStorage(String id, EventBus eventBus, ClusterCache<String, Object> clusterCache, long expires, Runnable doOnClear) {
        this.id = id;
        this.eventBus = eventBus;
        this.clusterCache = clusterCache;
        this.expires = expires;
        this.doOnClear = doOnClear;
    }

    public class Cache {
        final String key;
        long t;
        volatile int version;
        volatile Value cached;
        volatile Mono<Value> ref;
        Sinks.One<Value> sink;
        volatile Disposable loader;

        public Cache(String key) {
            this.key = key;
            this.updateTime();
        }

        boolean isExpired() {
            return LocalCacheClusterConfigStorage.this.expires > 0L && System.currentTimeMillis() - this.t > LocalCacheClusterConfigStorage.this.expires;
        }

        Mono<Value> getRef() {
            if (this.isExpired() || this.ref == null) {
                this.reload();
            }
            return this.ref;
        }

        public Value getCached() {
            if (this.isExpired()) {
                return null;
            }
            return this.cached;
        }

        public Object getCachedValue() {
            Value cached = this.getCached();
            return cached == null ? null : cached.get();
        }

        void updateTime() {
            if (LocalCacheClusterConfigStorage.this.expires > 0L) {
                this.t = System.currentTimeMillis();
            }
        }

        void setValue(Object value) {
            this.setValue(value == null ? null : Value.simple((Object)value));
        }

        void setValue(Value value) {
            this.updateTime();
            CACHE_VERSION.incrementAndGet(this);
            this.ref = Mono.justOrEmpty((Object)value);
            this.cached = value == null ? NULL : value;
            this.dispose();
        }

        synchronized void reload() {
            this.cached = null;
            this.dispose();
            int version = this.version;
            this.sink = Sinks.one();
            CACHE_REF.set(this, this.sink.asMono());
            this.loader = LocalCacheClusterConfigStorage.this.clusterCache.get((Object)this.key).switchIfEmpty(Mono.fromRunnable(() -> {
                if (version == this.version) {
                    this.setValue(null);
                } else {
                    this.clear();
                }
            })).subscribe(value -> {
                if (this.version == version) {
                    this.setValue(value);
                } else {
                    this.clear();
                }
            }, err -> {
                this.clear();
                this.sink.tryEmitError(err);
            });
        }

        void clear() {
            this.dispose();
            this.cached = null;
            CACHE_VERSION.incrementAndGet(this);
            CACHE_REF.set(this, null);
        }

        void dispose() {
            Disposable disposable = CACHE_LOADER.getAndSet(this, null);
            if (null != disposable) {
                disposable.dispose();
            }
            Sinks.One<Value> sink = this.sink;
            this.sink = null;
            if (sink != null) {
                Value value;
                Value value2 = value = this.cached != null ? this.cached : null;
                if (value == null || value.get() == null) {
                    sink.tryEmitEmpty();
                } else {
                    sink.tryEmitValue((Object)value);
                }
            }
        }
    }
}

