/*
 * Decompiled with CFR 0.152.
 */
package org.jetlinks.supports.official;

import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.jetlinks.core.metadata.EventMetadata;
import org.jetlinks.core.metadata.FunctionMetadata;
import org.jetlinks.core.metadata.Jsonable;
import org.jetlinks.core.metadata.MergeOption;
import org.jetlinks.core.metadata.Metadata;
import org.jetlinks.core.metadata.PropertyMetadata;
import org.jetlinks.core.things.ThingMetadata;
import org.jetlinks.supports.official.JetLinksDeviceFunctionMetadata;
import org.jetlinks.supports.official.JetLinksEventMetadata;
import org.jetlinks.supports.official.JetLinksPropertyMetadata;
import reactor.function.Function3;

public class DefaultThingsMetadata
implements ThingMetadata {
    private JSONObject jsonObject;
    private volatile Map<String, PropertyMetadata> properties;
    private volatile Map<String, FunctionMetadata> functions;
    private volatile Map<String, EventMetadata> events;
    private volatile Map<String, PropertyMetadata> tags;
    private volatile List<PropertyMetadata> propertyMetadataList;
    private String id;
    private String name;
    private String description;
    private Map<String, Object> expands;

    public DefaultThingsMetadata(String id, String name) {
        this.id = id;
        this.name = name;
    }

    public DefaultThingsMetadata(JSONObject jsonObject) {
        this.jsonObject = jsonObject;
    }

    public DefaultThingsMetadata(ThingMetadata another) {
        this.id = another.getId();
        this.name = another.getName();
        this.description = another.getDescription();
        this.expands = another.getExpands();
        this.properties = another.getProperties().stream().map(JetLinksPropertyMetadata::new).collect(Collectors.toMap(JetLinksPropertyMetadata::getId, Function.identity(), (a, b) -> a, LinkedHashMap::new));
        this.functions = another.getFunctions().stream().map(JetLinksDeviceFunctionMetadata::new).collect(Collectors.toMap(JetLinksDeviceFunctionMetadata::getId, Function.identity(), (a, b) -> a, LinkedHashMap::new));
        this.events = another.getEvents().stream().map(JetLinksEventMetadata::new).collect(Collectors.toMap(JetLinksEventMetadata::getId, Function.identity(), (a, b) -> a, LinkedHashMap::new));
        this.tags = another.getTags().stream().map(JetLinksPropertyMetadata::new).collect(Collectors.toMap(JetLinksPropertyMetadata::getId, Function.identity(), (a, b) -> a, LinkedHashMap::new));
    }

    public List<PropertyMetadata> getProperties() {
        if (CollectionUtils.isNotEmpty(this.propertyMetadataList)) {
            return this.propertyMetadataList;
        }
        if (this.properties == null && this.jsonObject != null) {
            this.properties = Optional.ofNullable(this.jsonObject.getJSONArray("properties")).map(Collection::stream).map(stream -> stream.map(JSONObject.class::cast).map(JetLinksPropertyMetadata::new).map(PropertyMetadata.class::cast).collect(Collectors.toMap(Metadata::getId, Function.identity(), (a, b) -> a, LinkedHashMap::new))).orElse(Collections.emptyMap());
        }
        if (this.propertyMetadataList == null && this.properties != null) {
            this.propertyMetadataList = Collections.unmodifiableList(new ArrayList<PropertyMetadata>(this.properties.values()));
            return this.propertyMetadataList;
        }
        return Collections.emptyList();
    }

    public List<FunctionMetadata> getFunctions() {
        if (this.functions == null && this.jsonObject != null) {
            this.functions = Optional.ofNullable(this.jsonObject.getJSONArray("functions")).map(Collection::stream).map(stream -> stream.map(JSONObject.class::cast).map(JetLinksDeviceFunctionMetadata::new).map(FunctionMetadata.class::cast).collect(Collectors.toMap(Metadata::getId, Function.identity(), (a, b) -> a, LinkedHashMap::new))).orElse(Collections.emptyMap());
        }
        if (this.functions == null) {
            this.functions = new HashMap<String, FunctionMetadata>();
        }
        return new ArrayList<FunctionMetadata>(this.functions.values());
    }

    public List<PropertyMetadata> getTags() {
        if (this.tags == null && this.jsonObject != null) {
            this.tags = Optional.ofNullable(this.jsonObject.getJSONArray("tags")).map(Collection::stream).map(stream -> stream.map(JSONObject.class::cast).map(JetLinksPropertyMetadata::new).map(PropertyMetadata.class::cast).collect(Collectors.toMap(Metadata::getId, Function.identity(), (a, b) -> a, LinkedHashMap::new))).orElse(Collections.emptyMap());
        }
        if (this.tags == null) {
            this.tags = new HashMap<String, PropertyMetadata>();
        }
        return new ArrayList<PropertyMetadata>(this.tags.values());
    }

    public List<EventMetadata> getEvents() {
        if (this.events == null && this.jsonObject != null) {
            this.events = Optional.ofNullable(this.jsonObject.getJSONArray("events")).map(Collection::stream).map(stream -> stream.map(JSONObject.class::cast).map(JetLinksEventMetadata::new).map(EventMetadata.class::cast).collect(Collectors.toMap(Metadata::getId, Function.identity(), (a, b) -> a, LinkedHashMap::new))).orElse(Collections.emptyMap());
        }
        if (this.events == null) {
            this.events = new HashMap<String, EventMetadata>();
        }
        return new ArrayList<EventMetadata>(this.events.values());
    }

    public EventMetadata getEventOrNull(String id) {
        if (this.events == null) {
            this.getEvents();
        }
        return this.events.get(id);
    }

    public PropertyMetadata getPropertyOrNull(String id) {
        if (this.properties == null) {
            this.getProperties();
        }
        return this.properties.get(id);
    }

    public FunctionMetadata getFunctionOrNull(String id) {
        if (this.functions == null) {
            this.getFunctions();
        }
        return this.functions.get(id);
    }

    public PropertyMetadata getTagOrNull(String id) {
        if (this.tags == null) {
            this.getTags();
        }
        return this.tags.get(id);
    }

    public PropertyMetadata findProperty(Predicate<PropertyMetadata> predicate) {
        if (this.properties == null) {
            this.getProperties();
        }
        for (Map.Entry<String, PropertyMetadata> value : this.properties.entrySet()) {
            PropertyMetadata val = value.getValue();
            if (!predicate.test(val)) continue;
            return val;
        }
        return null;
    }

    public void addProperty(PropertyMetadata metadata) {
        if (this.properties == null) {
            this.properties = new LinkedHashMap<String, PropertyMetadata>();
        }
        this.properties.put(metadata.getId(), new JetLinksPropertyMetadata(metadata));
        this.propertyMetadataList = Collections.unmodifiableList(new ArrayList<PropertyMetadata>(this.properties.values()));
    }

    public void addFunction(FunctionMetadata metadata) {
        if (this.functions == null) {
            this.functions = new LinkedHashMap<String, FunctionMetadata>();
        }
        this.functions.put(metadata.getId(), new JetLinksDeviceFunctionMetadata(metadata));
    }

    public void addEvent(EventMetadata metadata) {
        if (this.events == null) {
            this.events = new LinkedHashMap<String, EventMetadata>();
        }
        this.events.put(metadata.getId(), new JetLinksEventMetadata(metadata));
    }

    public void addTag(PropertyMetadata metadata) {
        if (this.tags == null) {
            this.tags = new LinkedHashMap<String, PropertyMetadata>();
        }
        this.tags.put(metadata.getId(), new JetLinksPropertyMetadata(metadata));
    }

    public Map<String, Object> getExpands() {
        if (this.expands == null && this.jsonObject != null) {
            this.expands = this.jsonObject.getJSONObject("expands");
        }
        return this.expands;
    }

    public JSONObject toJson() {
        JSONObject json = new JSONObject();
        json.put("id", (Object)this.id);
        json.put("name", (Object)this.name);
        json.put("description", (Object)this.description);
        json.put("properties", this.getProperties().stream().map(Jsonable::toJson).collect(Collectors.toList()));
        json.put("functions", this.getFunctions().stream().map(Jsonable::toJson).collect(Collectors.toList()));
        json.put("events", this.getEvents().stream().map(Jsonable::toJson).collect(Collectors.toList()));
        json.put("tags", this.getTags().stream().map(Jsonable::toJson).collect(Collectors.toList()));
        json.put("expands", this.expands);
        return json;
    }

    public void fromJson(JSONObject json) {
        this.jsonObject = json;
        this.properties = null;
        this.events = null;
        this.functions = null;
        this.tags = null;
        this.id = json.getString("id");
        this.name = json.getString("name");
        this.description = json.getString("description");
        this.expands = json.getJSONObject("expands");
    }

    private <V extends Metadata> void doMerge(Map<String, V> map, V value, Function3<V, V, MergeOption[], V> mergeFunction, MergeOption ... options) {
        map.compute(value.getId(), (k, old) -> {
            if (old == null) {
                return value;
            }
            if (MergeOption.has((MergeOption)MergeOption.ignoreExists, (MergeOption[])options)) {
                return old;
            }
            return (Metadata)mergeFunction.apply(old, (Object)value, (Object)options);
        });
    }

    protected DefaultThingsMetadata copy() {
        return new DefaultThingsMetadata(this);
    }

    public <T extends ThingMetadata> ThingMetadata merge(T metadata, MergeOption ... options) {
        DefaultThingsMetadata deviceMetadata = this.copy();
        if (MergeOption.has((MergeOption)MergeOption.overwriteProperty, (MergeOption[])options)) {
            deviceMetadata.properties.clear();
        }
        for (Object property : metadata.getProperties()) {
            this.doMerge(deviceMetadata.properties, property, PropertyMetadata::merge, options);
        }
        if (MergeOption.PropertyFilter.has((MergeOption[])options)) {
            LinkedHashMap<String, PropertyMetadata> temp = new LinkedHashMap<String, PropertyMetadata>(deviceMetadata.properties);
            deviceMetadata.properties.clear();
            for (Map.Entry entry : temp.entrySet()) {
                if (!MergeOption.PropertyFilter.doFilter((PropertyMetadata)((PropertyMetadata)entry.getValue()), (MergeOption[])options)) continue;
                deviceMetadata.properties.put((String)entry.getKey(), (PropertyMetadata)entry.getValue());
            }
        }
        for (FunctionMetadata func : metadata.getFunctions()) {
            this.doMerge(deviceMetadata.functions, func, FunctionMetadata::merge, options);
        }
        for (EventMetadata event : metadata.getEvents()) {
            this.doMerge(deviceMetadata.events, event, EventMetadata::merge, options);
        }
        for (PropertyMetadata tag : metadata.getTags()) {
            this.doMerge(deviceMetadata.tags, tag, PropertyMetadata::merge, options);
        }
        return deviceMetadata;
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public void setExpands(Map<String, Object> expands) {
        this.expands = expands;
    }
}

