/*
 * Decompiled with CFR 0.152.
 */
package org.jetlinks.supports.cluster.redis;

import java.io.Serializable;

public class NotifierMessageReply
implements Serializable {
    private String address;
    private String messageId;
    private Object payload;
    private boolean success;
    private String errorMessage;
    private boolean complete;

    public static NotifierMessageReply complete(String address, String messageId) {
        return NotifierMessageReply.of(address, messageId, null, true, null, true);
    }

    public static NotifierMessageReply success(String address, String messageId, Object payload) {
        return NotifierMessageReply.of(address, messageId, payload, true, null, false);
    }

    public static NotifierMessageReply fail(String address, String messageId, Throwable e) {
        return NotifierMessageReply.of(address, messageId, null, false, e.getClass().getName().concat(":").concat(String.valueOf(e.getMessage())), false);
    }

    public String getAddress() {
        return this.address;
    }

    public String getMessageId() {
        return this.messageId;
    }

    public Object getPayload() {
        return this.payload;
    }

    public boolean isSuccess() {
        return this.success;
    }

    public String getErrorMessage() {
        return this.errorMessage;
    }

    public boolean isComplete() {
        return this.complete;
    }

    public void setAddress(String address) {
        this.address = address;
    }

    public void setMessageId(String messageId) {
        this.messageId = messageId;
    }

    public void setPayload(Object payload) {
        this.payload = payload;
    }

    public void setSuccess(boolean success) {
        this.success = success;
    }

    public void setErrorMessage(String errorMessage) {
        this.errorMessage = errorMessage;
    }

    public void setComplete(boolean complete) {
        this.complete = complete;
    }

    private NotifierMessageReply(String address, String messageId, Object payload, boolean success, String errorMessage, boolean complete) {
        this.address = address;
        this.messageId = messageId;
        this.payload = payload;
        this.success = success;
        this.errorMessage = errorMessage;
        this.complete = complete;
    }

    public static NotifierMessageReply of(String address, String messageId, Object payload, boolean success, String errorMessage, boolean complete) {
        return new NotifierMessageReply(address, messageId, payload, success, errorMessage, complete);
    }

    public NotifierMessageReply() {
    }

    public String toString() {
        return "NotifierMessageReply(address=" + this.getAddress() + ", messageId=" + this.getMessageId() + ", payload=" + this.getPayload() + ", success=" + this.isSuccess() + ", errorMessage=" + this.getErrorMessage() + ", complete=" + this.isComplete() + ")";
    }
}

