/*
 * Decompiled with CFR 0.152.
 */
package org.jetlinks.supports.official.types;

import com.alibaba.fastjson.JSONObject;
import java.util.Map;
import java.util.Optional;
import org.jetlinks.core.metadata.types.BooleanType;
import org.jetlinks.supports.official.types.AbstractDataTypeCodec;

public class JetLinksBooleanCodec
extends AbstractDataTypeCodec<BooleanType> {
    public String getTypeId() {
        return "boolean";
    }

    @Override
    public BooleanType decode(BooleanType type, Map<String, Object> config) {
        super.decode(type, config);
        JSONObject jsonObject = new JSONObject(config);
        Optional.ofNullable(jsonObject.getString("trueText")).ifPresent(arg_0 -> ((BooleanType)type).setTrueText(arg_0));
        Optional.ofNullable(jsonObject.getString("falseText")).ifPresent(arg_0 -> ((BooleanType)type).setFalseText(arg_0));
        Optional.ofNullable(jsonObject.getString("trueValue")).ifPresent(arg_0 -> ((BooleanType)type).setTrueValue(arg_0));
        Optional.ofNullable(jsonObject.getString("falseValue")).ifPresent(arg_0 -> ((BooleanType)type).setFalseValue(arg_0));
        Optional.ofNullable(jsonObject.getString("description")).ifPresent(arg_0 -> ((BooleanType)type).setDescription(arg_0));
        return type;
    }

    @Override
    protected void doEncode(Map<String, Object> encoded, BooleanType type) {
        super.doEncode(encoded, type);
        encoded.put("trueText", type.getTrueText());
        encoded.put("falseText", type.getFalseText());
        encoded.put("trueValue", type.getTrueValue());
        encoded.put("falseValue", type.getFalseValue());
    }
}

