/*
 * Decompiled with CFR 0.152.
 */
package org.jetlinks.supports.official.types;

import com.alibaba.fastjson.JSONObject;
import java.time.ZoneId;
import java.util.Map;
import java.util.Optional;
import org.jetlinks.core.metadata.types.DateTimeType;
import org.jetlinks.supports.official.types.AbstractDataTypeCodec;

public class JetLinksDateCodec
extends AbstractDataTypeCodec<DateTimeType> {
    public String getTypeId() {
        return "date";
    }

    @Override
    public DateTimeType decode(DateTimeType type, Map<String, Object> config) {
        super.decode(type, config);
        JSONObject jsonObject = new JSONObject(config);
        Optional.ofNullable(jsonObject.getString("format")).ifPresent(arg_0 -> ((DateTimeType)type).setFormat(arg_0));
        Optional.ofNullable(jsonObject.getString("tz")).map(ZoneId::of).ifPresent(arg_0 -> ((DateTimeType)type).setZoneId(arg_0));
        return type;
    }

    @Override
    protected void doEncode(Map<String, Object> encoded, DateTimeType type) {
        super.doEncode(encoded, type);
        encoded.put("format", type.getFormat());
        encoded.put("tz", type.getZoneId().toString());
    }
}

