/*
 * Decompiled with CFR 0.152.
 */
package org.jetlinks.supports.official.types;

import com.alibaba.fastjson.JSONObject;
import java.math.RoundingMode;
import java.util.Map;
import java.util.Optional;
import org.jetlinks.core.metadata.types.NumberType;
import org.jetlinks.core.metadata.unit.ValueUnits;
import org.jetlinks.supports.official.types.AbstractDataTypeCodec;

public abstract class JetLinksNumberCodec<T extends NumberType<?>>
extends AbstractDataTypeCodec<T> {
    public abstract String getTypeId();

    @Override
    public T decode(T type, Map<String, Object> config) {
        super.decode(type, config);
        JSONObject jsonObject = new JSONObject(config);
        Optional.ofNullable(jsonObject.getDouble("max")).ifPresent(arg_0 -> type.setMax(arg_0));
        Optional.ofNullable(jsonObject.getDouble("min")).ifPresent(arg_0 -> type.setMin(arg_0));
        Optional.ofNullable(jsonObject.getInteger("scale")).ifPresent(arg_0 -> type.setScale(arg_0));
        Optional.ofNullable(jsonObject.getString("unit")).flatMap(ValueUnits::lookup).ifPresent(arg_0 -> type.setUnit(arg_0));
        Optional.ofNullable(jsonObject.getString("round")).map(RoundingMode::valueOf).ifPresent(arg_0 -> type.setRound(arg_0));
        return type;
    }

    @Override
    protected void doEncode(Map<String, Object> encoded, T type) {
        encoded.put("max", type.getMax());
        encoded.put("min", type.getMin());
        encoded.put("scale", type.getScale());
        encoded.put("round", type.getRound().name());
        if (type.getUnit() != null) {
            encoded.put("unit", type.getUnit().getId());
        }
    }
}

