/*
 * Decompiled with CFR 0.152.
 */
package org.jetlinks.supports.protocol;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.jetlinks.core.message.codec.MessagePayloadType;
import org.jetlinks.core.message.codec.MqttMessageCodecDescription;
import reactor.core.publisher.Flux;

public class DefaultMqttMessageCodecDescription
implements MqttMessageCodecDescription {
    private List<MqttMessageCodecDescription.Topic> upstream = new ArrayList<MqttMessageCodecDescription.Topic>();
    private List<MqttMessageCodecDescription.Topic> downstream = new ArrayList<MqttMessageCodecDescription.Topic>();

    public Flux<MqttMessageCodecDescription.Topic> getUpStreamTopics() {
        return Flux.fromIterable(this.upstream);
    }

    public Flux<MqttMessageCodecDescription.Topic> getDownStreamTopics() {
        return Flux.fromIterable(this.downstream);
    }

    public DefaultMqttMessageCodecDescription addUpstream(DefaultTopic.Builder builder) {
        this.upstream.add(builder.build());
        return this;
    }

    public DefaultMqttMessageCodecDescription addDownstream(DefaultTopic.Builder builder) {
        this.downstream.add(builder.build());
        return this;
    }

    public static class DefaultTopic
    implements MqttMessageCodecDescription.Topic {
        private String topic;
        private List<String> variables;
        private MessagePayloadType payloadType;
        private String templatePayload;
        private String description;

        public MessagePayloadType getPayloadType() {
            return this.payloadType;
        }

        public String getTopic() {
            return this.topic;
        }

        public String getTopic(Map<String, Object> variables) {
            String tp = this.topic;
            for (String variable : this.variables) {
                tp = tp.replace("{".concat(variable).concat("}"), String.valueOf(variables.get(variable)));
            }
            return tp;
        }

        DefaultTopic(String topic, List<String> variables, MessagePayloadType payloadType, String templatePayload, String description) {
            this.topic = topic;
            this.variables = variables;
            this.payloadType = payloadType;
            this.templatePayload = templatePayload;
            this.description = description;
        }

        public static Builder builder() {
            return new Builder();
        }

        public List<String> getVariables() {
            return this.variables;
        }

        public String getTemplatePayload() {
            return this.templatePayload;
        }

        public String getDescription() {
            return this.description;
        }

        public static class Builder {
            private String topic;
            private List<String> variables;
            private MessagePayloadType payloadType;
            private String templatePayload;
            private String description;

            Builder() {
            }

            public Builder topic(String topic) {
                this.topic = topic;
                return this;
            }

            public Builder variables(List<String> variables) {
                this.variables = variables;
                return this;
            }

            public Builder payloadType(MessagePayloadType payloadType) {
                this.payloadType = payloadType;
                return this;
            }

            public Builder templatePayload(String templatePayload) {
                this.templatePayload = templatePayload;
                return this;
            }

            public Builder description(String description) {
                this.description = description;
                return this;
            }

            public DefaultTopic build() {
                return new DefaultTopic(this.topic, this.variables, this.payloadType, this.templatePayload, this.description);
            }

            public String toString() {
                return "DefaultMqttMessageCodecDescription.DefaultTopic.Builder(topic=" + this.topic + ", variables=" + this.variables + ", payloadType=" + this.payloadType + ", templatePayload=" + this.templatePayload + ", description=" + this.description + ")";
            }
        }
    }
}

