/*
 * Decompiled with CFR 0.152.
 */
package org.jetlinks.supports.protocol.codec;

import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import org.jetlinks.supports.protocol.codec.BinaryCodec;
import org.jetlinks.supports.protocol.codec.BinaryDecoder;
import org.jetlinks.supports.protocol.codec.BinaryEncoder;
import org.jetlinks.supports.protocol.codec.Endian;
import org.jetlinks.supports.protocol.codec.defaults.AppendBinaryDecoder;
import org.jetlinks.supports.protocol.codec.defaults.BooleanCodec;
import org.jetlinks.supports.protocol.codec.defaults.ByteCodec;
import org.jetlinks.supports.protocol.codec.defaults.FixedValueDecoder;
import org.jetlinks.supports.protocol.codec.defaults.HexStringCodec;
import org.jetlinks.supports.protocol.codec.defaults.Ieee754DoubleCodec;
import org.jetlinks.supports.protocol.codec.defaults.Ieee754FloatCodec;
import org.jetlinks.supports.protocol.codec.defaults.LongCodec;
import org.jetlinks.supports.protocol.codec.defaults.MapBinaryDecoder;
import org.jetlinks.supports.protocol.codec.defaults.MapDecoderBuilder;
import org.jetlinks.supports.protocol.codec.defaults.StringCodec;
import org.jetlinks.supports.protocol.codec.defaults.TwoBytesFloatCodec;
import org.jetlinks.supports.protocol.codec.defaults.TwoBytesHexFloatCodec;

public interface BinaryCodecs {
    public static <T> BinaryCodec<T> of(final BinaryEncoder<T> encoder, final BinaryDecoder<T> decoder) {
        return new BinaryCodec<T>(){

            @Override
            public T decode(byte[] payload, int offset) {
                return decoder.decode(payload, offset);
            }

            @Override
            public void encode(T part, byte[] payload, int offset) {
                encoder.encode(part, payload, offset);
            }
        };
    }

    public static BinaryCodec<String> hex(int offset, int length) {
        return HexStringCodec.of(offset, length);
    }

    public static BinaryCodec<Boolean> bool(int offset) {
        return BooleanCodec.of(offset);
    }

    public static BinaryCodec<String> string(int offset, int length) {
        return BinaryCodecs.string(offset, length, StandardCharsets.UTF_8);
    }

    public static BinaryCodec<String> string(int offset, int length, Charset charset) {
        return StringCodec.of(charset, offset, length);
    }

    public static BinaryCodec<Byte> int1(int offset) {
        return ByteCodec.of(offset);
    }

    public static BinaryCodec<Short> int2(Endian endian, int offset) {
        return LongCodec.of(endian, offset, 2).transfer(Number::shortValue, Number::longValue);
    }

    public static BinaryCodec<Integer> int4(Endian endian, int offset) {
        return LongCodec.of(endian, offset, 4).transfer(Number::intValue, Number::longValue);
    }

    public static BinaryCodec<Long> int8(Endian endian, int offset) {
        return LongCodec.of(endian, offset, 8);
    }

    public static BinaryCodec<Float> ieee754Float(Endian endian, int offset) {
        return Ieee754FloatCodec.of(endian, offset);
    }

    public static BinaryCodec<Double> ieee754Double(Endian endian, int offset) {
        return Ieee754DoubleCodec.of(endian, offset);
    }

    public static BinaryCodec<Float> twoBytesHexFloat(Endian endian, int offset) {
        return TwoBytesHexFloatCodec.of(endian, offset);
    }

    public static BinaryCodec<Float> twoBytesFloat(Endian endian, int offset) {
        return TwoBytesFloatCodec.of(endian, offset);
    }

    public static interface Decoder {
        public static <T> BinaryDecoder<T> fixed(T value) {
            return FixedValueDecoder.of(value);
        }

        public static <K, V> MapDecoderBuilder<K, V> map() {
            return new MapBinaryDecoder();
        }

        public static AppendBinaryDecoder append(BinaryDecoder<?> ... decoders) {
            return AppendBinaryDecoder.of(decoders);
        }
    }
}

