/*
 * Decompiled with CFR 0.152.
 */
package org.jetlinks.supports.scalecube;

import io.scalecube.services.ServiceEndpoint;
import io.scalecube.services.ServiceReference;
import io.scalecube.services.api.ServiceMessage;
import io.scalecube.services.registry.ServiceRegistryImpl;
import io.scalecube.services.registry.api.ServiceRegistry;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.stream.Collectors;
import org.jctools.maps.NonBlockingHashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DynamicServiceRegistry
implements ServiceRegistry {
    private static final Logger LOGGER = LoggerFactory.getLogger(ServiceRegistryImpl.class);
    private final Map<String, ServiceEndpoint> serviceEndpoints = new NonBlockingHashMap();
    private final Map<String, List<ServiceReference>> serviceReferencesByQualifier = new NonBlockingHashMap();

    public List<ServiceEndpoint> listServiceEndpoints() {
        return new ArrayList<ServiceEndpoint>(this.serviceEndpoints.values());
    }

    public List<ServiceReference> listServiceReferences() {
        return this.serviceReferencesByQualifier.values().stream().flatMap(Collection::stream).collect(Collectors.toList());
    }

    public List<ServiceReference> lookupService(ServiceMessage request) {
        List<ServiceReference> list = this.serviceReferencesByQualifier.get(request.qualifier());
        if (list == null || list.isEmpty()) {
            return Collections.emptyList();
        }
        String contentType = request.dataFormatOrDefault();
        return list.stream().filter(sr -> sr.contentTypes().contains(contentType)).collect(Collectors.toList());
    }

    public boolean registerService(ServiceEndpoint serviceEndpoint) {
        this.serviceEndpoints.put(serviceEndpoint.id(), serviceEndpoint);
        LOGGER.debug("ServiceEndpoint registered: {}", (Object)serviceEndpoint);
        serviceEndpoint.serviceReferences().forEach(sr -> {
            this.populateServiceReferences(sr.qualifier(), (ServiceReference)sr);
            this.populateServiceReferences(sr.oldQualifier(), (ServiceReference)sr);
        });
        return true;
    }

    public ServiceEndpoint unregisterService(String endpointId) {
        ServiceEndpoint serviceEndpoint = this.serviceEndpoints.remove(endpointId);
        if (serviceEndpoint != null) {
            LOGGER.debug("ServiceEndpoint unregistered: {}", (Object)serviceEndpoint);
            List<ServiceReference> serviceReferencesOfEndpoint = this.serviceReferencesByQualifier.values().stream().flatMap(Collection::stream).filter(sr -> sr.endpointId().equals(endpointId)).collect(Collectors.toList());
            serviceReferencesOfEndpoint.forEach(sr -> {
                this.computeServiceReferences(sr.qualifier(), (ServiceReference)sr);
                this.computeServiceReferences(sr.oldQualifier(), (ServiceReference)sr);
            });
        }
        return serviceEndpoint;
    }

    private void populateServiceReferences(String qualifier, ServiceReference serviceReference) {
        this.serviceReferencesByQualifier.computeIfAbsent(qualifier, key -> new CopyOnWriteArrayList()).add(serviceReference);
    }

    private void computeServiceReferences(String qualifier, ServiceReference serviceReference) {
        this.serviceReferencesByQualifier.compute(qualifier, (key, list) -> {
            if (list == null || list.isEmpty()) {
                return null;
            }
            list.remove(serviceReference);
            return !list.isEmpty() ? list : null;
        });
    }
}

