/*
 * Decompiled with CFR 0.152.
 */
package org.jetlinks.rule.engine.api;

public interface RuleConstants {

    public static interface Topics {
        public static String prefix(String instanceId, String nodeId) {
            return "/rule-engine/" + instanceId + "/" + nodeId;
        }

        public static String input(String instanceId, String nodeId) {
            return Topics.prefix(instanceId, nodeId) + "/input";
        }

        public static String shutdown(String instanceId, String nodeId) {
            return Topics.prefix(instanceId, nodeId) + "/shutdown";
        }

        public static String event(String instanceId, String nodeId, String event) {
            return Topics.prefix(instanceId, nodeId) + "/event/" + event;
        }

        public static String logger(String instanceId, String nodeId, String level) {
            return Topics.prefix(instanceId, nodeId) + "/logger/" + level;
        }

        public static String state(String instanceId, String nodeId) {
            return Topics.prefix(instanceId, nodeId) + "/state";
        }
    }

    public static interface Event {
        public static final String error = "error";
        public static final String result = "result";
        public static final String complete = "complete";
        public static final String start = "start";
        public static final String paused = "paused";
    }

    public static interface Headers {
        public static final String ruleConfiguration = "ruleConf";
        public static final String jobExecutor = "jobExecutor";
        public static final String modelType = "modelType";
    }
}

