/*
 * Decompiled with CFR 0.152.
 */
package org.jetlinks.rule.engine.api;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.parser.Feature;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Consumer;
import org.hswebframework.web.bean.FastBeanCopier;
import org.hswebframework.web.id.IDGenerator;
import org.jetlinks.core.metadata.Jsonable;
import org.jetlinks.rule.engine.api.RuleDataHelper;
import reactor.core.publisher.Flux;
import reactor.core.publisher.FluxSink;

public class RuleData
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final String RECORD_DATA_TO_HEADER = "record_data_to_header";
    public static final String RECORD_DATA_TO_HEADER_KEY = "record_data_to_header_key";
    public static final String RECORD_DATA_TO_HEADER_KEY_PREFIX = "rd:";
    private String id;
    private String contextId;
    private Object data;
    private Map<String, Object> headers = new ConcurrentHashMap<String, Object>();

    public void setHeader(String key, Object value) {
        this.headers.put(key, value);
    }

    public void removeHeader(String key) {
        this.headers.remove(key);
    }

    public void clearHeader() {
        this.headers.clear();
    }

    public Optional<Object> getHeader(String key) {
        return Optional.ofNullable(this.headers.get(key));
    }

    public String getId() {
        return this.id;
    }

    public Object getData() {
        return this.data;
    }

    public Flux<Map<String, Object>> dataToMap() {
        return Flux.create((T sink) -> {
            this.acceptMap(arg_0 -> ((FluxSink)sink).next(arg_0));
            sink.complete();
        });
    }

    public void acceptMap(Consumer<Map<String, Object>> consumer) {
        String stringData;
        Object data = this.data;
        if (data == null) {
            return;
        }
        if (data instanceof byte[]) {
            byte[] bytes = (byte[])data;
            if (bytes.length > 2 && (bytes[0] == 123 && bytes[bytes.length - 1] == 125 || bytes[0] == 91 && bytes[bytes.length - 1] == 93)) {
                data = JSON.parse((byte[])bytes, (Feature[])new Feature[0]);
            }
        } else if (data instanceof String && ((stringData = (String)data).startsWith("{") || stringData.startsWith("["))) {
            data = JSON.parse((String)stringData);
        }
        if (data instanceof Map) {
            this.doAcceptMap(data, consumer);
        } else if (data instanceof RuleData) {
            ((RuleData)data).acceptMap(consumer);
        } else if (data instanceof Iterable) {
            ((Iterable)data).forEach(d -> this.doAcceptMap(d, consumer));
        } else {
            this.doAcceptMap(data, consumer);
        }
    }

    private void doAcceptMap(Object data, Consumer<Map<String, Object>> consumer) {
        if (data == null) {
            return;
        }
        if (data instanceof Map) {
            consumer.accept((Map)data);
        } else if (data instanceof Jsonable) {
            consumer.accept((Map<String, Object>)((Jsonable)data).toJson());
        } else {
            consumer.accept((Map<String, Object>)FastBeanCopier.copy((Object)data, HashMap::new, (String[])new String[0]));
        }
    }

    public RuleData newData(Object data) {
        RuleData ruleData = new RuleData();
        if (data instanceof RuleData) {
            data = ((RuleData)data).getData();
        }
        ruleData.id = (String)IDGenerator.RANDOM.generate();
        ruleData.headers.putAll(this.headers);
        ruleData.data = data;
        ruleData.contextId = this.contextId;
        RuleDataHelper.clearError(ruleData);
        return ruleData;
    }

    public RuleData copy() {
        RuleData ruleData = new RuleData();
        ruleData.id = this.id;
        ruleData.contextId = this.contextId;
        ruleData.headers.putAll(this.headers);
        ruleData.data = this.data;
        return ruleData;
    }

    public static RuleData create(Object data) {
        if (data instanceof RuleData) {
            return ((RuleData)data).newData(data);
        }
        RuleData ruleData = new RuleData();
        ruleData.setId((String)IDGenerator.RANDOM.generate());
        ruleData.setContextId((String)IDGenerator.RANDOM.generate());
        ruleData.setData(data);
        return ruleData;
    }

    public String getContextId() {
        return this.contextId;
    }

    public void setId(String id) {
        this.id = id;
    }

    public void setContextId(String contextId) {
        this.contextId = contextId;
    }

    public void setData(Object data) {
        this.data = data;
    }

    public void setHeaders(Map<String, Object> headers) {
        this.headers = headers;
    }

    public Map<String, Object> getHeaders() {
        return this.headers;
    }
}

