/*
 * Decompiled with CFR 0.152.
 */
package org.jetlinks.rule.engine.defaults;

import java.util.function.Function;
import org.jetlinks.rule.engine.api.RuleData;
import org.jetlinks.rule.engine.api.task.ExecutionContext;
import org.jetlinks.rule.engine.api.task.TaskExecutor;
import org.jetlinks.rule.engine.api.task.TaskExecutorProvider;
import org.jetlinks.rule.engine.defaults.LambdaTaskExecutor;
import org.reactivestreams.Publisher;
import reactor.core.publisher.Mono;

public class LambdaTaskExecutorProvider
implements TaskExecutorProvider {
    private final Function<RuleData, Publisher<?>> function;
    private final String executor;
    private final String name;

    public LambdaTaskExecutorProvider(String executor, Function<RuleData, Publisher<?>> function) {
        this(executor, executor, function);
    }

    public LambdaTaskExecutorProvider(String executor, String name, Function<RuleData, Publisher<?>> function) {
        this.function = function;
        this.executor = executor;
        this.name = name;
    }

    @Override
    public String getExecutor() {
        return this.executor;
    }

    @Override
    public Mono<TaskExecutor> createTask(ExecutionContext context) {
        return Mono.just((Object)new LambdaTaskExecutor(this.name, context, this.function));
    }
}

