/*
 * Decompiled with CFR 0.152.
 */
package org.jetlinks.rule.engine.defaults;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.jetlinks.core.event.EventBus;
import org.jetlinks.rule.engine.api.scheduler.ScheduleJob;
import org.jetlinks.rule.engine.api.task.ConditionEvaluator;
import org.jetlinks.rule.engine.api.task.Task;
import org.jetlinks.rule.engine.api.task.TaskExecutor;
import org.jetlinks.rule.engine.api.task.TaskExecutorProvider;
import org.jetlinks.rule.engine.api.worker.Worker;
import org.jetlinks.rule.engine.defaults.DefaultExecutionContext;
import org.jetlinks.rule.engine.defaults.DefaultTask;
import org.jetlinks.rule.engine.defaults.scope.InMemoryGlobalScope;
import reactor.core.publisher.Mono;

public class LocalWorker
implements Worker {
    private final Map<String, TaskExecutorProvider> executors = new ConcurrentHashMap<String, TaskExecutorProvider>();
    private final String id;
    private final String name;
    private final EventBus eventBus;
    private final ConditionEvaluator conditionEvaluator;
    private static final InMemoryGlobalScope scope = new InMemoryGlobalScope();

    public LocalWorker(String id, String name, EventBus eventBus, ConditionEvaluator evaluator) {
        this.id = id;
        this.name = name;
        this.eventBus = eventBus;
        this.conditionEvaluator = evaluator;
    }

    @Override
    public Mono<Task> createTask(String schedulerId, ScheduleJob job) {
        return Mono.justOrEmpty((Object)this.executors.get(job.getExecutor())).switchIfEmpty(Mono.error(() -> new UnsupportedOperationException("unsupported executor:" + job.getExecutor()))).flatMap(provider -> {
            DefaultExecutionContext context = this.createContext(job);
            return provider.createTask(context).map(executor -> new DefaultTask(schedulerId, this.getId(), context, (TaskExecutor)executor));
        });
    }

    protected DefaultExecutionContext createContext(ScheduleJob job) {
        return new DefaultExecutionContext(this.getId(), job, this.eventBus, this.conditionEvaluator, scope);
    }

    @Override
    public Mono<List<String>> getSupportExecutors() {
        return Mono.just(new ArrayList<String>(this.executors.keySet()));
    }

    @Override
    public Mono<Worker.State> getState() {
        return Mono.just((Object)((Object)Worker.State.working));
    }

    public void addExecutor(TaskExecutorProvider provider) {
        this.executors.put(provider.getExecutor(), provider);
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public String getName() {
        return this.name;
    }
}

