/*
 * Decompiled with CFR 0.152.
 */
package org.jetlinks.rule.engine.api;

import com.google.common.collect.Maps;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.function.Consumer;
import org.hswebframework.utils.StringUtils;
import org.jetlinks.rule.engine.api.RuleData;

public class RuleDataHelper {
    public static final String SYNC_RETURN = "sync_return";
    public static final String END_WITH_NODE = "end_with";
    public static final String SYNC_CONTEXT_ID = "sync_context_id";
    public static final String ERROR_TYPE = "error_type";
    public static final String ERROR_MESSAGE = "error_message";
    public static final String ERROR_STACK = "error_stack";
    public static final String START_WITH_NODE = "start_with";
    public static final String EXECUTE_TIME = "execute_time";
    public RuleData ruleData;

    private RuleDataHelper() {
    }

    public static RuleDataHelper newHelper(RuleData data) {
        RuleDataHelper helper = new RuleDataHelper();
        helper.ruleData = data;
        return helper;
    }

    public RuleData done() {
        return this.ruleData;
    }

    public RuleDataHelper markStartWith(String startWithNodeId) {
        this.ruleData.setHeader(START_WITH_NODE, startWithNodeId);
        return this;
    }

    public RuleDataHelper markEndWith(String endWithNodeId) {
        this.ruleData.setHeader(END_WITH_NODE, endWithNodeId);
        this.ruleData.setHeader(SYNC_RETURN, true);
        return this;
    }

    public RuleDataHelper whenSync(Consumer<RuleData> consumer) {
        if (RuleDataHelper.isSync(this.ruleData)) {
            consumer.accept(this.ruleData);
        }
        return this;
    }

    public static void markStartWith(RuleData data, String startWithNodeId) {
        data.setHeader(START_WITH_NODE, startWithNodeId);
    }

    public static void setExecuteTimeNow(RuleData data) {
        data.setHeader(EXECUTE_TIME, System.currentTimeMillis());
    }

    public static boolean isSync(RuleData data) {
        return data.getHeader(SYNC_RETURN).map(Boolean.class::cast).orElse(false);
    }

    public static Optional<String> getStartWithNodeId(RuleData data) {
        return data.getHeader(START_WITH_NODE).map(String::valueOf);
    }

    public static Optional<String> getEndWithNodeId(RuleData data) {
        return data.getHeader(END_WITH_NODE).map(String::valueOf);
    }

    public static RuleData markSyncReturn(RuleData data) {
        data.setHeader(SYNC_RETURN, true);
        return data;
    }

    public static boolean hasError(RuleData data) {
        return data.getHeader(ERROR_TYPE).isPresent();
    }

    public static RuleData putError(RuleData data, Throwable error) {
        while (error.getCause() != null) {
            error = error.getCause();
        }
        RuleDataHelper.putError(data, error.getClass().getName(), error.getMessage());
        String stack = StringUtils.throwable2String((Throwable)error);
        data.setHeader(ERROR_STACK, stack);
        return data;
    }

    public static RuleData putError(RuleData data, String type, String message) {
        data.setHeader(ERROR_TYPE, type);
        data.setHeader(ERROR_MESSAGE, message);
        return data;
    }

    public static RuleData clearError(RuleData data) {
        data.removeHeader(ERROR_TYPE);
        data.removeHeader(ERROR_MESSAGE);
        data.removeHeader(ERROR_STACK);
        return data;
    }

    public static RuleData markSyncReturn(RuleData data, String endWithId) {
        data.setHeader(SYNC_RETURN, true);
        data.setHeader(END_WITH_NODE, endWithId);
        return data;
    }

    public static Map<String, Object> toContextMap(RuleData ruleData) {
        HashMap map = Maps.newHashMapWithExpectedSize((int)32);
        ruleData.acceptMap(_map -> map.putAll(_map));
        if (map.isEmpty()) {
            map.put("data", ruleData.getData());
        }
        if (ruleData.getHeaders() != null) {
            for (Map.Entry<String, Object> entry : ruleData.getHeaders().entrySet()) {
                String key = entry.getKey();
                if (!key.startsWith("rd:")) continue;
                map.put(key.substring("rd:".length()), entry.getValue());
            }
        }
        return map;
    }
}

