/*
 * Decompiled with CFR 0.152.
 */
package org.jetlinks.rule.engine.api;

import org.jetlinks.rule.engine.api.Logger;
import org.slf4j.LoggerFactory;

public class Slf4jLogger
implements Logger {
    private static final org.slf4j.Logger log = LoggerFactory.getLogger(Slf4jLogger.class);
    private final String name;

    public Slf4jLogger(String name) {
        this.name = name;
    }

    @Override
    public void info(String message, Object ... args) {
        if (log.isInfoEnabled()) {
            log.info(this.name + ":" + message, args);
        }
    }

    @Override
    public void debug(String message, Object ... args) {
        if (log.isDebugEnabled()) {
            log.debug(this.name + ":" + message, args);
        }
    }

    @Override
    public void warn(String message, Object ... args) {
        log.warn(this.name + ":" + message, args);
    }

    @Override
    public void error(String message, Object ... args) {
        log.error(this.name + ":" + message, args);
    }
}

