/*
 * Decompiled with CFR 0.152.
 */
package org.jetlinks.rule.engine.api.task;

import org.jetlinks.rule.engine.api.RuleData;
import org.jetlinks.rule.engine.api.scheduler.ScheduleJob;
import org.jetlinks.rule.engine.api.task.TaskSnapshot;
import reactor.core.publisher.Mono;

public interface Task {
    public String getId();

    public String getName();

    public String getWorkerId();

    public String getSchedulerId();

    public ScheduleJob getJob();

    public Mono<Void> setJob(ScheduleJob var1);

    public Mono<Void> reload();

    public Mono<Void> start();

    public Mono<Void> pause();

    public Mono<Void> shutdown();

    public Mono<Void> execute(RuleData var1);

    public Mono<State> getState();

    public Mono<Void> debug(boolean var1);

    public Mono<Long> getLastStateTime();

    public Mono<Long> getStartTime();

    default public Mono<TaskSnapshot> dump() {
        return Mono.zip(this.getState(), this.getLastStateTime(), this.getStartTime()).map(tp3 -> {
            TaskSnapshot snapshot = new TaskSnapshot();
            snapshot.setId(this.getId());
            snapshot.setInstanceId(this.getJob().getInstanceId());
            snapshot.setJob(this.getJob());
            snapshot.setLastStateTime((Long)tp3.getT2());
            snapshot.setState((State)((Object)((Object)tp3.getT1())));
            snapshot.setWorkerId(this.getWorkerId());
            snapshot.setSchedulerId(this.getSchedulerId());
            snapshot.setStartTime((Long)tp3.getT3());
            return snapshot;
        });
    }

    default public boolean isSameTask(TaskSnapshot snapshot) {
        return this.getId().equals(snapshot.getId());
    }

    public static enum State {
        running,
        paused,
        shutdown,
        unknown;

    }
}

