/*
 * Decompiled with CFR 0.152.
 */
package org.jetlinks.rule.engine.cluster.balancer;

import java.util.List;
import org.jetlinks.core.event.EventBus;
import org.jetlinks.rule.engine.api.scheduler.Scheduler;
import org.jetlinks.rule.engine.api.task.Task;
import org.jetlinks.rule.engine.cluster.SchedulerRegistry;
import org.jetlinks.rule.engine.cluster.TaskSnapshotRepository;
import org.jetlinks.rule.engine.cluster.balancer.SchedulerLoadBalancer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.CollectionUtils;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public class DefaultSchedulerLoadBalancer
implements SchedulerLoadBalancer {
    private static final Logger log = LoggerFactory.getLogger(DefaultSchedulerLoadBalancer.class);
    private String id;
    private String leaderId;
    private long uptime;
    private boolean autoReBalance = true;
    private final EventBus eventBus;
    private final SchedulerRegistry registry;
    private final TaskSnapshotRepository snapshotRepository;

    public DefaultSchedulerLoadBalancer(EventBus eventBus, SchedulerRegistry registry, TaskSnapshotRepository snapshotRepository) {
        this.eventBus = eventBus;
        this.registry = registry;
        this.snapshotRepository = snapshotRepository;
    }

    public void setup() {
        this.uptime = System.currentTimeMillis();
        Flux.fromIterable(this.registry.getLocalSchedulers()).flatMap(scheduler -> this.snapshotRepository.findBySchedulerId(scheduler.getId()).filterWhen(snapshot -> scheduler.canSchedule(snapshot.getJob())).flatMap(snapshot -> scheduler.schedule(snapshot.getJob()).flatMap(task -> {
            if (snapshot.getState() == Task.State.running) {
                return task.start();
            }
            return Mono.empty();
        }).onErrorContinue((err, obj) -> log.debug(err.getMessage(), err)))).doOnError(err -> log.debug(err.getMessage(), err)).subscribe();
        if (!this.autoReBalance) {
            return;
        }
        this.registry.handleSchedulerLeave().subscribe(scheduler -> {});
        this.registry.handleSchedulerJoin().subscribe(scheduler -> {});
    }

    public void cleanup() {
    }

    public void tryReBalance(List<Scheduler> aliveSchedulers) {
    }

    @Override
    public Mono<Void> reBalance(List<Scheduler> schedulers, boolean balanceAll) {
        if (CollectionUtils.isEmpty(schedulers)) {
            return Mono.empty();
        }
        return Mono.empty();
    }

    public void setAutoReBalance(boolean autoReBalance) {
        this.autoReBalance = autoReBalance;
    }
}

