/*
 * Decompiled with CFR 0.152.
 */
package org.jinterop.dcom.core;

import java.io.Serializable;
import ndr.NdrException;
import ndr.NetworkDataRepresentation;
import org.jinterop.dcom.common.JISystem;
import org.jinterop.dcom.core.JIDualStringArray;
import org.jinterop.dcom.core.JIInterfacePointer;
import org.jinterop.dcom.core.JIStdObjRef;
import rpc.core.UUID;

class JIInterfacePointerBody
implements Serializable {
    private static final long serialVersionUID = 2597456459096838320L;
    private String iid = null;
    private String customCLSID = null;
    private int objectType = -1;
    private JIStdObjRef stdObjRef = null;
    private int length = -1;
    private JIDualStringArray resolverAddr = null;
    private int port = -1;

    private JIInterfacePointerBody() {
    }

    boolean isCustomObjRef() {
        return this.objectType == 4;
    }

    String getCustomCLSID() {
        return this.customCLSID;
    }

    JIInterfacePointerBody(String iid, int port, JIStdObjRef objref) {
        this.iid = iid;
        this.stdObjRef = objref;
        this.port = port;
        this.resolverAddr = new JIDualStringArray(port);
        this.length = 64 + this.resolverAddr.getLength();
    }

    JIInterfacePointerBody(String iid, JIInterfacePointer interfacePointer) {
        this.iid = iid;
        this.stdObjRef = (JIStdObjRef)interfacePointer.getObjectReference(1);
        this.resolverAddr = interfacePointer.getStringBindings();
        this.length = 64 + this.resolverAddr.getLength();
    }

    static JIInterfacePointerBody decode(NetworkDataRepresentation ndr, int Flags) {
        if ((Flags & 0x8000) == 32768) {
            return JIInterfacePointerBody.decode2(ndr);
        }
        int length = ndr.readUnsignedLong();
        ndr.readUnsignedLong();
        JIInterfacePointerBody ptr = new JIInterfacePointerBody();
        ptr.length = length;
        byte[] b = new byte[4];
        ndr.readOctetArray(b, 0, 4);
        int i = 0;
        while (i != 4) {
            if (b[i] != JIInterfacePointer.OBJREF_SIGNATURE[i]) {
                return null;
            }
            ++i;
        }
        ptr.objectType = ndr.readUnsignedLong();
        if (ptr.objectType != 1) {
            UUID ipid2;
            try {
                ipid2 = new UUID();
                ipid2.decode(ndr, ndr.getBuffer());
                ptr.iid = ipid2.toString();
            }
            catch (NdrException e) {
                JISystem.getLogger().throwing("JIInterfacePointer", "decode", e);
            }
            try {
                ipid2 = new UUID();
                ipid2.decode(ndr, ndr.getBuffer());
                ptr.customCLSID = ipid2.toString();
            }
            catch (NdrException e) {
                JISystem.getLogger().throwing("JIInterfacePointer", "decode", e);
            }
            ndr.readUnsignedLong();
            ndr.readUnsignedLong();
            return ptr;
        }
        try {
            UUID ipid2 = new UUID();
            ipid2.decode(ndr, ndr.getBuffer());
            ptr.iid = ipid2.toString();
        }
        catch (NdrException e) {
            JISystem.getLogger().throwing("JIInterfacePointer", "decode", e);
        }
        ptr.stdObjRef = JIStdObjRef.decode(ndr);
        ptr.resolverAddr = JIDualStringArray.decode(ndr);
        return ptr;
    }

    static JIInterfacePointerBody decode2(NetworkDataRepresentation ndr) {
        JIInterfacePointerBody ptr = new JIInterfacePointerBody();
        byte[] b = new byte[4];
        ndr.readOctetArray(b, 0, 4);
        int i = 0;
        while (i != 4) {
            if (b[i] != JIInterfacePointer.OBJREF_SIGNATURE[i]) {
                return null;
            }
            ++i;
        }
        ptr.objectType = ndr.readUnsignedLong();
        if (ptr.objectType != 1) {
            return null;
        }
        try {
            UUID ipid2 = new UUID();
            ipid2.decode(ndr, ndr.getBuffer());
            ptr.iid = ipid2.toString();
        }
        catch (NdrException e) {
            JISystem.getLogger().throwing("JIInterfacePointer", "decode", e);
        }
        ptr.stdObjRef = JIStdObjRef.decode(ndr);
        ptr.resolverAddr = JIDualStringArray.decode(ndr);
        return ptr;
    }

    int getObjectType() {
        return this.objectType;
    }

    Object getObjectReference(int objectType) {
        if (objectType == 1) {
            return this.stdObjRef;
        }
        return null;
    }

    String getIID() {
        return this.iid;
    }

    String getIPID() {
        return this.stdObjRef.getIpid();
    }

    byte[] getOID() {
        return this.stdObjRef.getObjectId();
    }

    JIDualStringArray getStringBindings() {
        return this.resolverAddr;
    }

    int getLength() {
        return this.length;
    }

    void encode(NetworkDataRepresentation ndr, int FLAGS) {
        int length = 0;
        if (!this.isCustomObjRef()) {
            length = 64 + this.resolverAddr.getLength();
        }
        ndr.writeUnsignedLong(length);
        ndr.writeUnsignedLong(length);
        ndr.writeOctetArray(JIInterfacePointer.OBJREF_SIGNATURE, 0, 4);
        if (this.isCustomObjRef()) {
            ndr.writeUnsignedLong(4);
            try {
                UUID ipid2 = new UUID(this.iid);
                ipid2.encode(ndr, ndr.getBuffer());
                ipid2 = new UUID(this.customCLSID);
                ipid2.encode(ndr, ndr.getBuffer());
                ndr.writeUnsignedLong(0);
                ndr.writeUnsignedLong(0);
            }
            catch (NdrException e) {
                e.printStackTrace();
            }
            return;
        }
        ndr.writeUnsignedLong(1);
        try {
            UUID ipid2 = new UUID(this.iid);
            if ((FLAGS & 0x10000) == 65536) {
                ipid2 = new UUID("00000000-0000-0000-c000-000000000046");
            } else if ((FLAGS & 0x20000) == 131072) {
                ipid2 = new UUID("00020400-0000-0000-c000-000000000046");
            }
            ipid2.encode(ndr, ndr.getBuffer());
        }
        catch (NdrException e) {
            e.printStackTrace();
        }
        this.stdObjRef.encode(ndr);
        this.resolverAddr.encode(ndr);
    }
}

