/*
 * Decompiled with CFR 0.152.
 */
package org.jinterop.dcom.transport.niosupport;

import java.io.IOException;
import java.lang.reflect.UndeclaredThrowableException;
import java.nio.channels.CancelledKeyException;
import java.nio.channels.SelectableChannel;
import java.nio.channels.SelectionKey;
import java.nio.channels.Selector;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.CountDownLatch;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.jinterop.dcom.common.JISystem;
import org.jinterop.dcom.transport.niosupport.ChannelListener;

public final class SelectorManager
implements Runnable {
    private final Selector selector;
    private final Thread selectThread;
    private final List<Runnable> taskList = new ArrayList<Runnable>();

    public SelectorManager() throws IOException {
        this.selectThread = new Thread((Runnable)this, "jI_SelectorManager");
        this.selectThread.setDaemon(true);
        this.selector = Selector.open();
        this.selectThread.start();
    }

    public void destroy() {
        if (this.selectThread.isAlive()) {
            this.selectThread.interrupt();
        }
    }

    void registerChannel(final SelectableChannel selectableChannel, final ChannelListener listener) throws IOException {
        Callable<Void> task = new Callable<Void>(){

            @Override
            public Void call() throws IOException {
                selectableChannel.configureBlocking(false);
                selectableChannel.register(SelectorManager.this.selector, 0, listener);
                return null;
            }
        };
        this.invokeSync(task);
    }

    void setReadInterest(final SelectableChannel selectableChannel) throws IOException {
        Callable<Void> task = new Callable<Void>(){

            @Override
            public Void call() throws IOException {
                SelectorManager.this.setInterestOps(selectableChannel, 1);
                return null;
            }
        };
        this.invokeSync(task);
    }

    void removeReadInterest(final SelectableChannel selectableChannel) throws IOException {
        Callable<Void> task = new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                SelectorManager.this.setInterestOps(selectableChannel, 0);
                return null;
            }
        };
        this.invokeSync(task);
    }

    private void setInterestOps(SelectableChannel selectableChannel, int interestOps) throws IOException {
        try {
            if (selectableChannel.isRegistered()) {
                SelectionKey selectionKey = selectableChannel.keyFor(this.selector);
                selectionKey.interestOps(interestOps);
            }
        }
        catch (CancelledKeyException e) {
            throw new IOException("Unable to set interest ops", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void invokeAsync(Runnable task) {
        List<Runnable> list = this.taskList;
        synchronized (list) {
            this.taskList.add(task);
        }
        this.selector.wakeup();
    }

    private void invokeSync(final Callable<Void> task) throws IOException {
        final ExceptionHolder exceptionHolder = new ExceptionHolder();
        if (Thread.currentThread() == this.selectThread) {
            try {
                task.call();
            }
            catch (Exception e) {
                exceptionHolder.setException(e);
            }
        } else {
            final CountDownLatch latch = new CountDownLatch(1);
            this.invokeAsync(new Runnable(){

                @Override
                public void run() {
                    try {
                        try {
                            task.call();
                        }
                        catch (Exception e) {
                            exceptionHolder.setException(e);
                            latch.countDown();
                        }
                    }
                    finally {
                        latch.countDown();
                    }
                }
            });
            try {
                latch.await();
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
        }
        if (exceptionHolder.getException() != null) {
            Exception thrownException = exceptionHolder.getException();
            throw this.launderIOException(thrownException);
        }
    }

    private IOException launderIOException(Exception thrownException) {
        if (thrownException instanceof RuntimeException) {
            throw (RuntimeException)thrownException;
        }
        if (thrownException instanceof IOException) {
            return (IOException)thrownException;
        }
        throw new UndeclaredThrowableException(thrownException);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doInvocations() {
        boolean processedTask = false;
        List<Runnable> list = this.taskList;
        synchronized (list) {
            for (Runnable task : this.taskList) {
                task.run();
                processedTask = true;
            }
            this.taskList.clear();
        }
        if (!processedTask) {
            try {
                Thread.sleep(0L, 1);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
        }
    }

    @Override
    public void run() {
        try {
            while (true) {
                if (Thread.currentThread().isInterrupted()) {
                    JISystem.getLogger().log(Level.INFO, "Selector manager interrupted");
                    return;
                }
                this.doInvocations();
                this.doSelect();
            }
        }
        catch (Exception t) {
            this.cleanup();
            this.getLogger().log(Level.SEVERE, "Selector manager is unexpectedly exiting", t);
            return;
        }
    }

    private void doSelect() {
        try {
            if (this.selector.select() != 0) {
                Iterator<SelectionKey> it = this.selector.selectedKeys().iterator();
                while (it.hasNext()) {
                    try {
                        SelectionKey selectionKey = it.next();
                        it.remove();
                        selectionKey.interestOps(0);
                        ChannelListener listener = (ChannelListener)selectionKey.attachment();
                        listener.readReady();
                    }
                    catch (CancelledKeyException e) {
                        if (!this.getLogger().isLoggable(Level.FINE)) continue;
                        this.getLogger().log(Level.FINE, "Ignoring cancelled key exception", e);
                    }
                }
            }
        }
        catch (IOException e) {
            this.getLogger().log(Level.WARNING, "Exception during SelectionManager select", e);
        }
    }

    private void cleanup() {
        block5: {
            for (SelectionKey key : this.selector.keys()) {
                try {
                    key.channel().close();
                }
                catch (IOException e) {
                    if (!this.getLogger().isLoggable(Level.FINE)) continue;
                    this.getLogger().log(Level.FINE, "Ignoring channel close exception", e);
                }
            }
            try {
                this.selector.close();
            }
            catch (IOException e) {
                if (!this.getLogger().isLoggable(Level.FINE)) break block5;
                this.getLogger().log(Level.FINE, "Ignoring selector close exception", e);
            }
        }
    }

    private Logger getLogger() {
        return JISystem.getLogger();
    }

    private static class ExceptionHolder {
        private Exception exception;

        private ExceptionHolder() {
        }

        Exception getException() {
            return this.exception;
        }

        void setException(Exception e) {
            this.exception = e;
        }
    }
}

