/*
 * Decompiled with CFR 0.152.
 */
package jodd.http;

import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.StringWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.util.Collections;
import java.util.Map;
import jodd.datetime.TimeUtil;
import jodd.http.Buffer;
import jodd.http.HttpException;
import jodd.http.HttpProgressListener;
import jodd.http.HttpUtil;
import jodd.http.HttpValuesMap;
import jodd.http.JoddHttp;
import jodd.http.up.ByteArrayUploadable;
import jodd.http.up.FileUploadable;
import jodd.http.up.Uploadable;
import jodd.io.FastCharArrayWriter;
import jodd.io.FileNameUtil;
import jodd.io.StreamUtil;
import jodd.upload.MultipartStreamParser;
import jodd.util.MimeTypes;
import jodd.util.RandomStringUtil;
import jodd.util.StringUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class HttpBase<T> {
    public static final String HEADER_ACCEPT = "Accept";
    public static final String HEADER_ACCEPT_ENCODING = "Accept-Encoding";
    public static final String HEADER_CONTENT_TYPE = "Content-Type";
    public static final String HEADER_CONTENT_LENGTH = "Content-Length";
    public static final String HEADER_CONTENT_ENCODING = "Content-Encoding";
    public static final String HEADER_HOST = "Host";
    public static final String HEADER_ETAG = "ETag";
    public static final String HEADER_CONNECTION = "Connection";
    public static final String HEADER_KEEP_ALIVE = "Keep-Alive";
    public static final String HEADER_CLOSE = "Close";
    public static final String HTTP_1_0 = "HTTP/1.0";
    public static final String HTTP_1_1 = "HTTP/1.1";
    protected String httpVersion = "HTTP/1.1";
    protected HttpValuesMap<String> headers = HttpValuesMap.ofStrings();
    protected HttpValuesMap<Object> form;
    protected String body;
    protected String charset;
    protected String mediaType;
    protected String formEncoding = JoddHttp.defaultFormEncoding;
    protected boolean multipart = false;
    protected HttpProgressListener httpProgressListener;

    public String httpVersion() {
        return this.httpVersion;
    }

    public T httpVersion(String httpVersion) {
        this.httpVersion = httpVersion;
        return (T)this;
    }

    public String header(String name) {
        String key = name.trim().toLowerCase();
        String value = this.headers.getFirst(key);
        if (value == null) {
            return null;
        }
        return value.toString();
    }

    public String[] headers(String name) {
        String key = name.trim().toLowerCase();
        return this.headers.getStrings(key);
    }

    public void removeHeader(String name) {
        String key = name.trim().toLowerCase();
        this.headers.remove(key);
    }

    public T header(String name, String value) {
        return this.header(name, value, false);
    }

    public T header(String name, String value, boolean overwrite) {
        String key = name.trim().toLowerCase();
        value = value.trim();
        if (key.equalsIgnoreCase(HEADER_CONTENT_TYPE)) {
            this.mediaType = HttpUtil.extractMediaType(value);
            this.charset = HttpUtil.extractContentTypeCharset(value);
        }
        if (overwrite) {
            this.headers.set(key, value);
        } else {
            this.headers.add(key, value);
        }
        return (T)this;
    }

    protected void _header(String name, String value, boolean overwrite) {
        String key = name.trim().toLowerCase();
        value = value.trim();
        if (overwrite) {
            this.headers.set(key, value);
        } else {
            this.headers.add(key, value);
        }
    }

    public T header(String name, int value) {
        this._header(name, String.valueOf(value), false);
        return (T)this;
    }

    public T header(String name, long millis) {
        this._header(name, TimeUtil.formatHttpDate((long)millis), false);
        return (T)this;
    }

    public Map<String, String[]> headers() {
        return Collections.unmodifiableMap(this.headers);
    }

    public String charset() {
        return this.charset;
    }

    public T charset(String charset) {
        this.charset = null;
        this.contentType(null, charset);
        return (T)this;
    }

    public String mediaType() {
        return this.mediaType;
    }

    public T mediaType(String mediaType) {
        this.contentType(mediaType, null);
        return (T)this;
    }

    public String contentType() {
        return this.header(HEADER_CONTENT_TYPE);
    }

    public T contentType(String contentType) {
        this.header(HEADER_CONTENT_TYPE, contentType, true);
        return (T)this;
    }

    public T contentType(String mediaType, String charset) {
        if (mediaType == null) {
            mediaType = this.mediaType;
        } else {
            this.mediaType = mediaType;
        }
        if (charset == null) {
            charset = this.charset;
        } else {
            this.charset = charset;
        }
        String contentType = mediaType;
        if (charset != null) {
            contentType = contentType + ";charset=" + charset;
        }
        this._header(HEADER_CONTENT_TYPE, contentType, true);
        return (T)this;
    }

    public T connectionKeepAlive(boolean keepAlive) {
        if (keepAlive) {
            this.header(HEADER_CONNECTION, HEADER_KEEP_ALIVE, true);
        } else {
            this.header(HEADER_CONNECTION, HEADER_CLOSE, true);
        }
        return (T)this;
    }

    public boolean isConnectionPersistent() {
        String connection = this.header(HEADER_CONNECTION);
        if (connection == null) {
            return !this.httpVersion.equalsIgnoreCase(HTTP_1_0);
        }
        return !connection.equalsIgnoreCase(HEADER_CLOSE);
    }

    public String contentLength() {
        return this.header(HEADER_CONTENT_LENGTH);
    }

    public T contentLength(int value) {
        this._header(HEADER_CONTENT_LENGTH, String.valueOf(value), true);
        return (T)this;
    }

    public String contentEncoding() {
        return this.header(HEADER_CONTENT_ENCODING);
    }

    public String accept() {
        return this.header(HEADER_ACCEPT);
    }

    public T accept(String encodings) {
        this.header(HEADER_ACCEPT, encodings, true);
        return (T)this;
    }

    public String acceptEncoding() {
        return this.header(HEADER_ACCEPT_ENCODING);
    }

    public T acceptEncoding(String encodings) {
        this.header(HEADER_ACCEPT_ENCODING, encodings, true);
        return (T)this;
    }

    protected void initForm() {
        if (this.form == null) {
            this.form = HttpValuesMap.ofObjects();
        }
    }

    protected Object wrapFormValue(Object value) {
        if (value == null) {
            return null;
        }
        if (value instanceof CharSequence) {
            return value.toString();
        }
        if (value instanceof File) {
            return new FileUploadable((File)value);
        }
        if (value instanceof byte[]) {
            return new ByteArrayUploadable((byte[])value, null);
        }
        if (value instanceof Uploadable) {
            return value;
        }
        throw new HttpException("Unsupported value type: " + value.getClass().getName());
    }

    public T form(String name, Object value) {
        this.initForm();
        value = this.wrapFormValue(value);
        this.form.add(name, value);
        return (T)this;
    }

    public T form(String name, Object value, boolean overwrite) {
        this.initForm();
        value = this.wrapFormValue(value);
        if (overwrite) {
            this.form.set(name, value);
        } else {
            this.form.add(name, value);
        }
        return (T)this;
    }

    public T form(String name, Object value, Object ... parameters) {
        this.initForm();
        this.form(name, value);
        for (int i = 0; i < parameters.length; i += 2) {
            name = parameters[i].toString();
            this.form(name, parameters[i + 1]);
        }
        return (T)this;
    }

    public T form(Map<String, Object> formMap) {
        this.initForm();
        for (Map.Entry<String, Object> entry : formMap.entrySet()) {
            this.form(entry.getKey(), entry.getValue());
        }
        return (T)this;
    }

    public Map<String, Object[]> form() {
        return this.form;
    }

    public T formEncoding(String encoding) {
        this.formEncoding = encoding;
        return (T)this;
    }

    public String body() {
        return this.body;
    }

    public byte[] bodyBytes() {
        if (this.body == null) {
            return null;
        }
        try {
            return this.body.getBytes("ISO-8859-1");
        }
        catch (UnsupportedEncodingException ignore) {
            return null;
        }
    }

    public String bodyText() {
        if (this.body == null) {
            return "";
        }
        if (this.charset != null) {
            return StringUtil.convertCharset((String)this.body, (String)"ISO-8859-1", (String)this.charset);
        }
        return this.body();
    }

    public T body(String body) {
        this.body = body;
        this.form = null;
        this.contentLength(body.length());
        return (T)this;
    }

    public T bodyText(String body, String mediaType, String charset) {
        body = StringUtil.convertCharset((String)body, (String)charset, (String)"ISO-8859-1");
        this.contentType(mediaType, charset);
        this.body(body);
        return (T)this;
    }

    public T bodyText(String body, String mediaType) {
        return this.bodyText(body, mediaType, JoddHttp.defaultBodyEncoding);
    }

    public T bodyText(String body) {
        return this.bodyText(body, JoddHttp.defaultBodyMediaType, JoddHttp.defaultBodyEncoding);
    }

    public T body(byte[] content, String contentType) {
        String body = null;
        try {
            body = new String(content, "ISO-8859-1");
        }
        catch (UnsupportedEncodingException ignore) {
            // empty catch block
        }
        this.contentType(contentType);
        return this.body(body);
    }

    protected boolean isFormMultipart() {
        if (this.multipart) {
            return true;
        }
        for (Object[] values : this.form.values()) {
            if (values == null) continue;
            for (Object value : values) {
                if (!(value instanceof Uploadable)) continue;
                return true;
            }
        }
        return false;
    }

    protected Buffer formBuffer() {
        Buffer buffer = new Buffer();
        if (this.form == null || this.form.isEmpty()) {
            return buffer;
        }
        if (!this.isFormMultipart()) {
            String formEncoding = this.charset;
            if (formEncoding == null) {
                formEncoding = this.formEncoding;
            }
            String formQueryString = HttpUtil.buildQuery(this.form, formEncoding);
            this.contentType("application/x-www-form-urlencoded", null);
            this.contentLength(formQueryString.length());
            buffer.append(formQueryString);
            return buffer;
        }
        String boundary = StringUtil.repeat((char)'-', (int)10) + RandomStringUtil.randomAlphaNumeric((int)10);
        for (Map.Entry entry : this.form.entrySet()) {
            Object[] values;
            buffer.append("--");
            buffer.append(boundary);
            buffer.append("\r\n");
            String name = (String)entry.getKey();
            for (Object value : values = (Object[])entry.getValue()) {
                if (value instanceof String) {
                    String string = (String)value;
                    buffer.append("Content-Disposition: form-data; name=\"").append(name).append('\"').append("\r\n");
                    buffer.append("\r\n");
                    buffer.append(string);
                } else if (value instanceof Uploadable) {
                    Uploadable uploadable = (Uploadable)value;
                    String fileName = uploadable.getFileName();
                    if (fileName == null) {
                        fileName = name;
                    }
                    buffer.append("Content-Disposition: form-data; name=\"").append(name);
                    buffer.append("\"; filename=\"").append(fileName).append('\"').append("\r\n");
                    String mimeType = uploadable.getMimeType();
                    if (mimeType == null) {
                        mimeType = MimeTypes.getMimeType((String)FileNameUtil.getExtension((String)fileName));
                    }
                    buffer.append(HEADER_CONTENT_TYPE).append(": ").append(mimeType).append("\r\n");
                    buffer.append("Content-Transfer-Encoding: binary").append("\r\n");
                    buffer.append("\r\n");
                    buffer.append(uploadable);
                } else {
                    throw new HttpException("Unsupported type");
                }
                buffer.append("\r\n");
            }
        }
        buffer.append("--").append(boundary).append("--");
        buffer.append("\r\n");
        this.contentType("multipart/form-data; boundary=" + boundary);
        this.contentLength(buffer.size());
        return buffer;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean fullResponse) {
        Buffer buffer = this.buffer(fullResponse);
        StringWriter stringWriter = new StringWriter();
        try {
            buffer.writeTo(stringWriter);
        }
        catch (IOException ioex) {
            throw new HttpException(ioex);
        }
        return stringWriter.toString();
    }

    public byte[] toByteArray() {
        Buffer buffer = this.buffer(true);
        ByteArrayOutputStream baos = new ByteArrayOutputStream(buffer.size());
        try {
            buffer.writeTo(baos);
        }
        catch (IOException ioex) {
            throw new HttpException(ioex);
        }
        return baos.toByteArray();
    }

    protected abstract Buffer buffer(boolean var1);

    public void sendTo(OutputStream out) throws IOException {
        Buffer buffer = this.buffer(true);
        if (this.httpProgressListener == null) {
            buffer.writeTo(out);
        } else {
            buffer.writeTo(out, this.httpProgressListener);
        }
        out.flush();
    }

    protected void readHeaders(BufferedReader reader) {
        block3: {
            String line;
            while (true) {
                try {
                    line = reader.readLine();
                }
                catch (IOException ioex) {
                    throw new HttpException(ioex);
                }
                if (StringUtil.isBlank((CharSequence)line)) break block3;
                int ndx = line.indexOf(58);
                if (ndx == -1) break;
                this.header(line.substring(0, ndx), line.substring(ndx + 1));
            }
            throw new HttpException("Invalid header: " + line);
        }
    }

    protected void readBody(BufferedReader reader) {
        String charset;
        FastCharArrayWriter fastCharArrayWriter;
        String transferEncoding;
        String bodyString = null;
        String contentLen = this.contentLength();
        int contentLenValue = -1;
        if (contentLen != null && (contentLenValue = Integer.parseInt(contentLen)) > 0) {
            FastCharArrayWriter fastCharArrayWriter2 = new FastCharArrayWriter(contentLenValue);
            try {
                StreamUtil.copy((Reader)reader, (Writer)fastCharArrayWriter2, (int)contentLenValue);
            }
            catch (IOException ioex) {
                throw new HttpException(ioex);
            }
            bodyString = fastCharArrayWriter2.toString();
        }
        if ((transferEncoding = this.header("Transfer-Encoding")) != null && transferEncoding.equalsIgnoreCase("chunked")) {
            fastCharArrayWriter = new FastCharArrayWriter();
            try {
                String line;
                int len;
                while ((len = Integer.parseInt(line = reader.readLine(), 16)) > 0) {
                    StreamUtil.copy((Reader)reader, (Writer)fastCharArrayWriter, (int)len);
                    reader.readLine();
                }
                this.readHeaders(reader);
            }
            catch (IOException ioex) {
                throw new HttpException(ioex);
            }
            bodyString = fastCharArrayWriter.toString();
        }
        if (bodyString == null && contentLenValue != 0) {
            fastCharArrayWriter = new FastCharArrayWriter();
            try {
                StreamUtil.copy((Reader)reader, (Writer)fastCharArrayWriter);
            }
            catch (IOException ioex) {
                throw new HttpException(ioex);
            }
            bodyString = fastCharArrayWriter.toString();
        }
        if ((charset = this.charset) == null) {
            charset = "ISO-8859-1";
        }
        this.body = bodyString;
        String mediaType = this.mediaType();
        mediaType = mediaType == null ? "" : mediaType.toLowerCase();
        if (mediaType.equals("application/x-www-form-urlencoded")) {
            this.form = HttpUtil.parseQuery(bodyString, true);
            return;
        }
        if (mediaType.equals("multipart/form-data")) {
            String[] values;
            this.form = HttpValuesMap.ofObjects();
            MultipartStreamParser multipartParser = new MultipartStreamParser();
            try {
                byte[] bodyBytes = bodyString.getBytes("ISO-8859-1");
                ByteArrayInputStream bin = new ByteArrayInputStream(bodyBytes);
                multipartParser.parseRequestStream((InputStream)bin, charset);
            }
            catch (IOException ioex) {
                throw new HttpException(ioex);
            }
            for (String paramName : multipartParser.getParameterNames()) {
                values = multipartParser.getParameterValues(paramName);
                if (values.length == 1) {
                    this.form.add(paramName, values[0]);
                    continue;
                }
                this.form.put(paramName, values);
            }
            for (String paramName : multipartParser.getFileParameterNames()) {
                values = multipartParser.getFiles(paramName);
                if (values.length == 1) {
                    this.form.add(paramName, values[0]);
                    continue;
                }
                this.form.put(paramName, values);
            }
            return;
        }
        this.form = null;
    }
}

