/*
 * Decompiled with CFR 0.152.
 */
package org.jxls.transform.jexcel;

import jxl.Cell;
import jxl.CellView;
import jxl.Sheet;
import org.jxls.common.CellRef;
import org.jxls.common.RowData;
import org.jxls.transform.Transformer;
import org.jxls.transform.jexcel.JexcelCellData;
import org.jxls.transform.jexcel.JexcelTransformer;

public class JexcelRowData
extends RowData {
    Cell[] cells;

    public static RowData createRowData(Sheet sheet, int rowNum, JexcelTransformer transformer) {
        return JexcelRowData.createRowData(sheet.getName(), sheet.getRow(rowNum), sheet.getRowView(rowNum), transformer);
    }

    public static RowData createRowData(String sheetName, Cell[] cells, CellView rowCellView, JexcelTransformer transformer) {
        if (cells == null) {
            return null;
        }
        JexcelRowData rowData = new JexcelRowData();
        rowData.setTransformer((Transformer)transformer);
        rowData.cells = cells;
        rowData.height = rowCellView.getSize();
        int numberOfCells = cells.length;
        for (int cellIndex = 0; cellIndex < numberOfCells; ++cellIndex) {
            Cell cell = cells[cellIndex];
            if (cell != null) {
                JexcelCellData cellData = JexcelCellData.createCellData(new CellRef(sheetName, cell.getRow(), cellIndex), cell);
                cellData.setTransformer((Transformer)transformer);
                rowData.addCellData(cellData);
                continue;
            }
            rowData.addCellData(null);
        }
        return rowData;
    }

    public Cell[] getRow() {
        return this.cells;
    }
}

