/*
 * Decompiled with CFR 0.152.
 */
package com.sun.star.lib.uno.protocols.urp;

import com.sun.star.lib.uno.environments.remote.ThreadId;
import com.sun.star.lib.uno.typedesc.FieldDescription;
import com.sun.star.lib.uno.typedesc.TypeDescription;
import com.sun.star.uno.Any;
import com.sun.star.uno.Enum;
import com.sun.star.uno.IBridge;
import com.sun.star.uno.Type;
import com.sun.star.uno.TypeClass;
import com.sun.star.uno.XInterface;
import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.Array;
import java.lang.reflect.InvocationTargetException;

final class Unmarshal {
    private final IBridge bridge;
    private final String[] objectIdCache;
    private final ThreadId[] threadIdCache;
    private final TypeDescription[] typeCache;
    private DataInputStream input;

    public Unmarshal(IBridge bridge, int cacheSize) {
        this.bridge = bridge;
        this.objectIdCache = new String[cacheSize];
        this.threadIdCache = new ThreadId[cacheSize];
        this.typeCache = new TypeDescription[cacheSize];
        this.reset(new byte[0]);
    }

    public int read8Bit() {
        try {
            return this.input.readUnsignedByte();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public int read16Bit() {
        try {
            return this.input.readUnsignedShort();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public String readObjectId() {
        try {
            String id = this.readStringValue();
            int index = this.read16Bit();
            if (index == 65535) {
                if (id.length() == 0) {
                    id = null;
                }
            } else if (id.length() == 0) {
                id = this.objectIdCache[index];
            } else {
                this.objectIdCache[index] = id;
            }
            return id;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public Object readInterface(Type type) {
        String id = this.readObjectId();
        return id == null ? null : this.bridge.mapInterfaceFrom((Object)id, type);
    }

    public ThreadId readThreadId() {
        try {
            int index;
            int len = this.readCompressedNumber();
            ThreadId id = null;
            if (len != 0) {
                byte[] data = new byte[len];
                this.readBytes(data);
                id = new ThreadId(data);
            }
            if ((index = this.read16Bit()) != 65535) {
                if (len == 0) {
                    id = this.threadIdCache[index];
                } else {
                    this.threadIdCache[index] = id;
                }
            }
            return id;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public TypeDescription readType() {
        TypeDescription type;
        int b = this.read8Bit();
        TypeClass typeClass = TypeClass.fromInt((int)(b & 0x7F));
        if (typeClass == null) {
            throw new RuntimeException("Reading TYPE with bad type class " + (b & 0x7F));
        }
        if (TypeDescription.isTypeClassSimple((TypeClass)typeClass)) {
            if ((b & 0x80) != 0) {
                throw new RuntimeException("Reading TYPE with bad type class/cache flag " + b);
            }
            return TypeDescription.getTypeDescription((TypeClass)typeClass);
        }
        int index = this.read16Bit();
        if ((b & 0x80) == 0) {
            if (index >= this.typeCache.length) {
                throw new RuntimeException("Reading TYPE with bad cache index " + index);
            }
            type = this.typeCache[index];
            if (type == null) {
                throw new RuntimeException("Reading TYPE with empty cache index " + index);
            }
        } else {
            try {
                type = TypeDescription.getTypeDescription((String)this.readStringValue());
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
            catch (ClassNotFoundException e) {
                throw new RuntimeException(e);
            }
            if (index != 65535) {
                if (index >= this.typeCache.length) {
                    throw new RuntimeException("Reading TYPE with bad cache index " + index);
                }
                this.typeCache[index] = type;
            }
        }
        return type;
    }

    public Object readValue(TypeDescription type) {
        try {
            switch (type.getTypeClass().getValue()) {
                case 0: {
                    return null;
                }
                case 2: {
                    return this.readBooleanValue();
                }
                case 3: {
                    return this.readByteValue();
                }
                case 4: 
                case 5: {
                    return this.readShortValue();
                }
                case 6: 
                case 7: {
                    return this.readLongValue();
                }
                case 8: 
                case 9: {
                    return this.readHyperValue();
                }
                case 10: {
                    return this.readFloatValue();
                }
                case 11: {
                    return this.readDoubleValue();
                }
                case 1: {
                    return this.readCharValue();
                }
                case 12: {
                    return this.readStringValue();
                }
                case 13: {
                    return this.readTypeValue();
                }
                case 14: {
                    return this.readAnyValue();
                }
                case 20: {
                    return this.readSequenceValue(type);
                }
                case 15: {
                    return this.readEnumValue(type);
                }
                case 17: {
                    return this.readStructValue(type);
                }
                case 19: {
                    return this.readExceptionValue(type);
                }
                case 22: {
                    return this.readInterfaceValue(type);
                }
            }
            throw new IllegalArgumentException("Bad type descriptor " + type);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public boolean hasMore() {
        try {
            return this.input.available() > 0;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public void reset(byte[] data) {
        this.input = new DataInputStream(new ByteArrayInputStream(data));
    }

    private Boolean readBooleanValue() throws IOException {
        return this.input.readBoolean() ? Boolean.TRUE : Boolean.FALSE;
    }

    private Byte readByteValue() throws IOException {
        return this.input.readByte();
    }

    private Short readShortValue() throws IOException {
        return this.input.readShort();
    }

    private Integer readLongValue() throws IOException {
        return this.input.readInt();
    }

    private Long readHyperValue() throws IOException {
        return this.input.readLong();
    }

    private Float readFloatValue() throws IOException {
        return new Float(this.input.readFloat());
    }

    private Double readDoubleValue() throws IOException {
        return new Double(this.input.readDouble());
    }

    private Character readCharValue() throws IOException {
        return new Character(this.input.readChar());
    }

    private String readStringValue() throws IOException {
        int len = this.readCompressedNumber();
        byte[] data = new byte[len];
        this.readBytes(data);
        try {
            return new String(data, "UTF8");
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
    }

    private Type readTypeValue() {
        return new Type(this.readType());
    }

    private Object readAnyValue() throws IOException {
        TypeDescription type = this.readType();
        switch (type.getTypeClass().getValue()) {
            case 0: {
                return Any.VOID;
            }
            case 2: {
                return this.readBooleanValue();
            }
            case 3: {
                return this.readByteValue();
            }
            case 4: {
                return this.readShortValue();
            }
            case 5: {
                return new Any(Type.UNSIGNED_SHORT, (Object)this.readShortValue());
            }
            case 6: {
                return this.readLongValue();
            }
            case 7: {
                return new Any(Type.UNSIGNED_LONG, (Object)this.readLongValue());
            }
            case 8: {
                return this.readHyperValue();
            }
            case 9: {
                return new Any(Type.UNSIGNED_HYPER, (Object)this.readHyperValue());
            }
            case 10: {
                return this.readFloatValue();
            }
            case 11: {
                return this.readDoubleValue();
            }
            case 1: {
                return this.readCharValue();
            }
            case 12: {
                return this.readStringValue();
            }
            case 13: {
                return this.readTypeValue();
            }
            case 20: {
                Object value = this.readSequenceValue(type);
                TypeDescription ctype = type.getComponentType();
                while (ctype.getTypeClass() == TypeClass.SEQUENCE) {
                    ctype = ctype.getComponentType();
                }
                switch (ctype.getTypeClass().getValue()) {
                    case 5: 
                    case 7: 
                    case 9: {
                        return new Any(new Type(type), value);
                    }
                    case 17: {
                        if (!ctype.hasTypeArguments()) break;
                        return new Any(new Type(type), value);
                    }
                }
                return value;
            }
            case 15: {
                return this.readEnumValue(type);
            }
            case 17: {
                Object value = this.readStructValue(type);
                return type.hasTypeArguments() ? new Any(new Type(type), value) : value;
            }
            case 19: {
                return this.readExceptionValue(type);
            }
            case 22: {
                Object value = this.readInterfaceValue(type);
                return type.getZClass() == XInterface.class ? value : new Any(new Type(type), value);
            }
        }
        throw new RuntimeException("Reading ANY with bad type " + type.getTypeClass());
    }

    private Object readSequenceValue(TypeDescription type) throws IOException {
        int len = this.readCompressedNumber();
        TypeDescription ctype = type.getComponentType();
        if (ctype.getTypeClass() == TypeClass.BYTE) {
            byte[] data = new byte[len];
            this.readBytes(data);
            return data;
        }
        Object value = Array.newInstance(ctype.getTypeClass() == TypeClass.ANY ? Object.class : ctype.getZClass(), len);
        for (int i = 0; i < len; ++i) {
            Array.set(value, i, this.readValue(ctype));
        }
        return value;
    }

    private Enum readEnumValue(TypeDescription type) throws IOException {
        try {
            return (Enum)type.getZClass().getMethod("fromInt", Integer.TYPE).invoke(null, this.readLongValue());
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
        catch (InvocationTargetException e) {
            throw new RuntimeException(e);
        }
        catch (NoSuchMethodException e) {
            throw new RuntimeException(e);
        }
    }

    private Object readStructValue(TypeDescription type) {
        Object value;
        try {
            value = type.getZClass().newInstance();
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
        catch (InstantiationException e) {
            throw new RuntimeException(e);
        }
        this.readFields(type, value);
        return value;
    }

    private Exception readExceptionValue(TypeDescription type) throws IOException {
        Exception value;
        try {
            value = (Exception)type.getZClass().getConstructor(String.class).newInstance(this.readStringValue());
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
        catch (InstantiationException e) {
            throw new RuntimeException(e);
        }
        catch (InvocationTargetException e) {
            throw new RuntimeException(e);
        }
        catch (NoSuchMethodException e) {
            throw new RuntimeException(e);
        }
        this.readFields(type, value);
        return value;
    }

    private Object readInterfaceValue(TypeDescription type) {
        return this.readInterface(new Type(type));
    }

    private int readCompressedNumber() throws IOException {
        int number = this.read8Bit();
        return number < 255 ? number : this.input.readInt();
    }

    private void readBytes(byte[] data) throws IOException {
        this.input.readFully(data);
    }

    private void readFields(TypeDescription type, Object value) {
        FieldDescription[] fields = type.getFieldDescriptions();
        for (int i = 0; i < fields.length; ++i) {
            try {
                fields[i].getField().set(value, this.readValue(fields[i].getTypeDescription()));
                continue;
            }
            catch (IllegalAccessException e) {
                throw new RuntimeException(e);
            }
        }
    }
}

