/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.logback.ext.spring.web;

import ch.qos.logback.core.joran.spi.JoranException;
import ch.qos.logback.ext.spring.LogbackConfigurer;
import java.io.FileNotFoundException;
import java.lang.reflect.Method;
import javax.servlet.ServletContext;
import org.springframework.util.ClassUtils;
import org.springframework.util.ReflectionUtils;
import org.springframework.util.ResourceUtils;
import org.springframework.util.SystemPropertyUtils;
import org.springframework.web.util.WebUtils;

public class WebLogbackConfigurer {
    public static final String CONFIG_LOCATION_PARAM = "logbackConfigLocation";
    public static final String EXPOSE_WEB_APP_ROOT_PARAM = "logbackExposeWebAppRoot";

    private WebLogbackConfigurer() {
    }

    public static void initLogging(ServletContext servletContext) {
        String string;
        if (WebLogbackConfigurer.exposeWebAppRoot(servletContext)) {
            WebUtils.setWebAppRootSystemProperty((ServletContext)servletContext);
        }
        if ((string = servletContext.getInitParameter(CONFIG_LOCATION_PARAM)) != null) {
            try {
                string = SystemPropertyUtils.resolvePlaceholders((String)string);
                if (!ResourceUtils.isUrl((String)string)) {
                    string = WebUtils.getRealPath((ServletContext)servletContext, (String)string);
                }
                servletContext.log("Initializing Logback from [" + string + "]");
                LogbackConfigurer.initLogging(string);
            }
            catch (FileNotFoundException fileNotFoundException) {
                throw new IllegalArgumentException("Invalid 'logbackConfigLocation' parameter: " + fileNotFoundException.getMessage());
            }
            catch (JoranException joranException) {
                throw new RuntimeException("Unexpected error while configuring logback", joranException);
            }
        }
        try {
            Method method;
            Class clazz = ClassUtils.forName((String)"org.slf4j.bridge.SLF4JBridgeHandler", (ClassLoader)ClassUtils.getDefaultClassLoader());
            Method method2 = ReflectionUtils.findMethod((Class)clazz, (String)"removeHandlersForRootLogger");
            if (method2 != null) {
                servletContext.log("Removing all previous handlers for JUL to SLF4J bridge");
                ReflectionUtils.invokeMethod((Method)method2, null);
            }
            if ((method = ReflectionUtils.findMethod((Class)clazz, (String)"install")) != null) {
                servletContext.log("Installing JUL to SLF4J bridge");
                ReflectionUtils.invokeMethod((Method)method, null);
            }
        }
        catch (ClassNotFoundException classNotFoundException) {
            servletContext.log("JUL to SLF4J bridge is not available on the classpath");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void shutdownLogging(ServletContext servletContext) {
        try {
            Class clazz = ClassUtils.forName((String)"org.slf4j.bridge.SLF4JBridgeHandler", (ClassLoader)ClassUtils.getDefaultClassLoader());
            Method method = ReflectionUtils.findMethod((Class)clazz, (String)"uninstall");
            if (method != null) {
                servletContext.log("Uninstalling JUL to SLF4J bridge");
                ReflectionUtils.invokeMethod((Method)method, null);
            }
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        try {
            servletContext.log("Shutting down Logback");
            LogbackConfigurer.shutdownLogging();
        }
        finally {
            if (WebLogbackConfigurer.exposeWebAppRoot(servletContext)) {
                WebUtils.removeWebAppRootSystemProperty((ServletContext)servletContext);
            }
        }
    }

    private static boolean exposeWebAppRoot(ServletContext servletContext) {
        String string = servletContext.getInitParameter(EXPOSE_WEB_APP_ROOT_PARAM);
        return string == null || Boolean.valueOf(string) != false;
    }
}

