/*
 * Decompiled with CFR 0.152.
 */
package org.mariadb.r2dbc.codec.list;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import java.nio.charset.StandardCharsets;
import java.time.DateTimeException;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeFormatterBuilder;
import java.time.temporal.ChronoField;
import java.util.EnumSet;
import org.mariadb.r2dbc.ExceptionFactory;
import org.mariadb.r2dbc.codec.Codec;
import org.mariadb.r2dbc.codec.DataType;
import org.mariadb.r2dbc.codec.list.LocalDateCodec;
import org.mariadb.r2dbc.codec.list.LocalTimeCodec;
import org.mariadb.r2dbc.message.Context;
import org.mariadb.r2dbc.message.server.ColumnDefinitionPacket;

public class LocalDateTimeCodec
implements Codec<LocalDateTime> {
    public static final LocalDateTimeCodec INSTANCE = new LocalDateTimeCodec();
    public static final DateTimeFormatter TIMESTAMP_FORMAT = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss.SSSSSS");
    public static final DateTimeFormatter TIMESTAMP_FORMAT_NO_FRACTIONAL = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss");
    public static final DateTimeFormatter MARIADB_LOCAL_DATE_TIME;
    private static final EnumSet<DataType> COMPATIBLE_TYPES;

    public static int[] parseTimestamp(String raw) {
        int nanoLen = -1;
        int[] timestampsPart = new int[]{0, 0, 0, 0, 0, 0, 0};
        int partIdx = 0;
        for (int idx = 0; idx < raw.length(); ++idx) {
            char b = raw.charAt(idx);
            if (b == '-' || b == ' ' || b == ':') {
                ++partIdx;
                continue;
            }
            if (b == '.') {
                ++partIdx;
                nanoLen = 0;
                continue;
            }
            if (nanoLen >= 0) {
                ++nanoLen;
            }
            timestampsPart[partIdx] = timestampsPart[partIdx] * 10 + b - 48;
        }
        if (timestampsPart[0] == 0 && timestampsPart[1] == 0 && timestampsPart[2] == 0) {
            if (timestampsPart[3] == 0 && timestampsPart[4] == 0 && timestampsPart[5] == 0 && timestampsPart[6] == 0) {
                return null;
            }
            timestampsPart[1] = 1;
            timestampsPart[2] = 1;
        }
        if (nanoLen >= 0) {
            for (int begin = 0; begin < 6 - nanoLen; ++begin) {
                timestampsPart[6] = timestampsPart[6] * 10;
            }
            timestampsPart[6] = timestampsPart[6] * 1000;
        }
        return timestampsPart;
    }

    @Override
    public boolean canDecode(ColumnDefinitionPacket column, Class<?> type) {
        return COMPATIBLE_TYPES.contains((Object)column.getDataType()) && type.isAssignableFrom(LocalDateTime.class);
    }

    @Override
    public boolean canEncode(Class<?> value) {
        return LocalDateTime.class.isAssignableFrom(value);
    }

    @Override
    public LocalDateTime decodeText(ByteBuf buf, int length, ColumnDefinitionPacket column, Class<? extends LocalDateTime> type, ExceptionFactory factory) {
        switch (column.getDataType()) {
            case DATE: {
                int[] parts = LocalDateCodec.parseDate(buf, length);
                if (parts == null) {
                    return null;
                }
                return LocalDateTime.of(parts[0], parts[1], parts[2], 0, 0, 0);
            }
            case DATETIME: 
            case TIMESTAMP: {
                int[] parts = LocalDateTimeCodec.parseTimestamp(buf.readCharSequence(length, StandardCharsets.US_ASCII).toString());
                if (parts == null) {
                    return null;
                }
                return LocalDateTime.of(parts[0], parts[1], parts[2], parts[3], parts[4], parts[5]).plusNanos(parts[6]);
            }
            case TIME: {
                int[] parts = LocalTimeCodec.parseTime(buf, length, column, factory);
                return LocalDateTime.of(1970, 1, 1, parts[1] % 24, parts[2], parts[3]).plusNanos(parts[4]);
            }
        }
        String val = buf.readCharSequence(length, StandardCharsets.UTF_8).toString();
        try {
            int[] parts = LocalDateTimeCodec.parseTimestamp(val);
            if (parts == null) {
                return null;
            }
            return LocalDateTime.of(parts[0], parts[1], parts[2], parts[3], parts[4], parts[5]).plusNanos(parts[6]);
        }
        catch (DateTimeException dte) {
            throw factory.createParsingException(String.format("value '%s' (%s) cannot be decoded as LocalDateTime", new Object[]{val, column.getDataType()}));
        }
    }

    @Override
    public LocalDateTime decodeBinary(ByteBuf buf, int length, ColumnDefinitionPacket column, Class<? extends LocalDateTime> type, ExceptionFactory factory) {
        int year = 1970;
        byte month = 1;
        long dayOfMonth = 1L;
        byte hour = 0;
        int minutes = 0;
        int seconds = 0;
        long microseconds = 0L;
        switch (column.getDataType()) {
            case TIME: {
                if (length <= 0) break;
                buf.skipBytes(5);
                hour = buf.readByte();
                minutes = buf.readByte();
                seconds = buf.readByte();
                if (length <= 8) break;
                microseconds = buf.readUnsignedIntLE();
                break;
            }
            case DATE: 
            case DATETIME: 
            case TIMESTAMP: {
                if (length > 0) {
                    year = buf.readUnsignedShortLE();
                    month = buf.readByte();
                    dayOfMonth = buf.readByte();
                    if (length <= 4) break;
                    hour = buf.readByte();
                    minutes = buf.readByte();
                    seconds = buf.readByte();
                    if (length <= 7) break;
                    microseconds = buf.readUnsignedIntLE();
                    break;
                }
                return null;
            }
            default: {
                String val = buf.readCharSequence(length, StandardCharsets.UTF_8).toString();
                try {
                    int[] parts = LocalDateTimeCodec.parseTimestamp(val);
                    if (parts == null) {
                        return null;
                    }
                    return LocalDateTime.of(parts[0], parts[1], parts[2], parts[3], parts[4], parts[5]).plusNanos(parts[6]);
                }
                catch (DateTimeException dte) {
                    throw factory.createParsingException(String.format("value '%s' (%s) cannot be decoded as LocalDateTime", new Object[]{val, column.getDataType()}));
                }
            }
        }
        return LocalDateTime.of(year, month, (int)dayOfMonth, (int)hour, minutes, seconds).plusNanos(microseconds * 1000L);
    }

    @Override
    public void encodeDirectText(ByteBuf out, Object value, Context context) {
        LocalDateTime val = (LocalDateTime)value;
        out.writeByte(39);
        out.writeCharSequence((CharSequence)val.format(val.getNano() != 0 ? TIMESTAMP_FORMAT : TIMESTAMP_FORMAT_NO_FRACTIONAL), StandardCharsets.US_ASCII);
        out.writeByte(39);
    }

    @Override
    public void encodeDirectBinary(ByteBufAllocator allocator, ByteBuf out, Object value, Context context) {
        LocalDateTime val = (LocalDateTime)value;
        int nano = val.getNano();
        if (nano > 0) {
            out.writeByte(11);
            out.writeShortLE((int)((short)val.get(ChronoField.YEAR)));
            out.writeByte(val.get(ChronoField.MONTH_OF_YEAR));
            out.writeByte(val.get(ChronoField.DAY_OF_MONTH));
            out.writeByte(val.get(ChronoField.HOUR_OF_DAY));
            out.writeByte(val.get(ChronoField.MINUTE_OF_HOUR));
            out.writeByte(val.get(ChronoField.SECOND_OF_MINUTE));
            out.writeIntLE(nano / 1000);
        } else {
            out.writeByte(7);
            out.writeShortLE((int)((short)val.get(ChronoField.YEAR)));
            out.writeByte(val.get(ChronoField.MONTH_OF_YEAR));
            out.writeByte(val.get(ChronoField.DAY_OF_MONTH));
            out.writeByte(val.get(ChronoField.HOUR_OF_DAY));
            out.writeByte(val.get(ChronoField.MINUTE_OF_HOUR));
            out.writeByte(val.get(ChronoField.SECOND_OF_MINUTE));
        }
    }

    @Override
    public DataType getBinaryEncodeType() {
        return DataType.DATETIME;
    }

    static {
        COMPATIBLE_TYPES = EnumSet.of(DataType.DATETIME, new DataType[]{DataType.TIMESTAMP, DataType.VARSTRING, DataType.TEXT, DataType.STRING, DataType.TIME, DataType.DATE});
        MARIADB_LOCAL_DATE_TIME = new DateTimeFormatterBuilder().parseCaseInsensitive().append(DateTimeFormatter.ISO_LOCAL_DATE).appendLiteral(' ').append(DateTimeFormatter.ISO_LOCAL_TIME).toFormatter();
    }
}

