/*
 * Decompiled with CFR 0.152.
 */
package org.mariadb.r2dbc.codec.list;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.nio.charset.StandardCharsets;
import java.util.EnumSet;
import org.mariadb.r2dbc.ExceptionFactory;
import org.mariadb.r2dbc.codec.Codec;
import org.mariadb.r2dbc.codec.DataType;
import org.mariadb.r2dbc.codec.list.LongCodec;
import org.mariadb.r2dbc.message.Context;
import org.mariadb.r2dbc.message.server.ColumnDefinitionPacket;

public class ShortCodec
implements Codec<Short> {
    public static final ShortCodec INSTANCE = new ShortCodec();
    private static final EnumSet<DataType> COMPATIBLE_TYPES = EnumSet.of(DataType.FLOAT, new DataType[]{DataType.DOUBLE, DataType.OLDDECIMAL, DataType.TEXT, DataType.DECIMAL, DataType.ENUM, DataType.VARSTRING, DataType.STRING, DataType.TINYINT, DataType.SMALLINT, DataType.MEDIUMINT, DataType.INTEGER, DataType.BIGINT, DataType.BIT, DataType.YEAR});

    @Override
    public boolean canDecode(ColumnDefinitionPacket column, Class<?> type) {
        return COMPATIBLE_TYPES.contains((Object)column.getDataType()) && (type.isPrimitive() && type == Short.TYPE || type.isAssignableFrom(Short.class));
    }

    @Override
    public boolean canEncode(Class<?> value) {
        return Short.class.isAssignableFrom(value);
    }

    @Override
    public Short decodeText(ByteBuf buf, int length, ColumnDefinitionPacket column, Class<? extends Short> type, ExceptionFactory factory) {
        long result;
        switch (column.getDataType()) {
            case TINYINT: 
            case SMALLINT: 
            case MEDIUMINT: 
            case INTEGER: 
            case BIGINT: 
            case YEAR: {
                result = LongCodec.parse(buf, length);
                break;
            }
            case BIT: {
                result = 0L;
                for (int i = 0; i < length; ++i) {
                    byte b = buf.readByte();
                    result = (result << 8) + (long)(b & 0xFF);
                }
                break;
            }
            default: {
                String str = buf.readCharSequence(length, StandardCharsets.UTF_8).toString();
                try {
                    result = new BigDecimal(str).setScale(0, RoundingMode.DOWN).longValueExact();
                    break;
                }
                catch (ArithmeticException | NumberFormatException nfe) {
                    throw factory.createParsingException(String.format("value '%s' cannot be decoded as Short", str));
                }
            }
        }
        if ((long)((short)result) != result || result < 0L && !column.isSigned()) {
            throw factory.createParsingException("Short overflow");
        }
        return (short)result;
    }

    @Override
    public Short decodeBinary(ByteBuf buf, int length, ColumnDefinitionPacket column, Class<? extends Short> type, ExceptionFactory factory) {
        long result;
        switch (column.getDataType()) {
            case TINYINT: {
                result = column.isSigned() ? (long)buf.readByte() : (long)buf.readUnsignedByte();
                break;
            }
            case SMALLINT: 
            case YEAR: {
                result = column.isSigned() ? (long)buf.readShortLE() : (long)buf.readUnsignedShortLE();
                break;
            }
            case MEDIUMINT: {
                result = column.isSigned() ? (long)buf.readMediumLE() : (long)buf.readUnsignedMediumLE();
                break;
            }
            case INTEGER: {
                result = column.isSigned() ? (long)buf.readIntLE() : buf.readUnsignedIntLE();
                break;
            }
            case BIGINT: {
                result = buf.readLongLE();
                if (!(result < 0L & !column.isSigned())) break;
                throw factory.createParsingException("Short overflow");
            }
            case BIT: {
                result = 0L;
                for (int i = 0; i < length; ++i) {
                    byte b = buf.readByte();
                    result = (result << 8) + (long)(b & 0xFF);
                }
                break;
            }
            case FLOAT: {
                result = (long)buf.readFloatLE();
                break;
            }
            case DOUBLE: {
                result = (long)buf.readDoubleLE();
                break;
            }
            default: {
                String str = buf.readCharSequence(length, StandardCharsets.UTF_8).toString();
                try {
                    result = new BigDecimal(str).setScale(0, RoundingMode.DOWN).longValueExact();
                    break;
                }
                catch (ArithmeticException | NumberFormatException nfe) {
                    throw factory.createParsingException(String.format("value '%s' cannot be decoded as Short", str));
                }
            }
        }
        if ((long)((short)result) != result || result < 0L && !column.isSigned()) {
            throw factory.createParsingException("Short overflow");
        }
        return (short)result;
    }

    @Override
    public void encodeDirectText(ByteBuf out, Object value, Context context) {
        out.writeCharSequence((CharSequence)value.toString(), StandardCharsets.US_ASCII);
    }

    @Override
    public void encodeDirectBinary(ByteBufAllocator allocator, ByteBuf out, Object value, Context context) {
        out.writeShortLE((int)((Short)value).shortValue());
    }

    @Override
    public DataType getBinaryEncodeType() {
        return DataType.SMALLINT;
    }
}

