/*
 * Decompiled with CFR 0.152.
 */
package org.mariadb.r2dbc.message.server;

import io.netty.buffer.ByteBuf;
import org.mariadb.r2dbc.message.Context;
import org.mariadb.r2dbc.message.ServerMessage;
import org.mariadb.r2dbc.message.server.Sequencer;
import org.mariadb.r2dbc.util.BufferUtils;

public class ColumnCountPacket
implements ServerMessage {
    private final int columnCount;
    private final boolean metaFollows;

    public ColumnCountPacket(int columnCount, boolean metaFollows) {
        this.columnCount = columnCount;
        this.metaFollows = metaFollows;
    }

    public static ColumnCountPacket decode(Sequencer sequencer, ByteBuf buf, Context context) {
        long columnCount = BufferUtils.readLengthEncodedInt(buf);
        boolean metaFollow = true;
        if ((context.getServerCapabilities() & 0x1000000000L) > 0L) {
            metaFollow = buf.readByte() == 1;
        }
        return new ColumnCountPacket((int)columnCount, metaFollow);
    }

    public int getColumnCount() {
        return this.columnCount;
    }

    public boolean isMetaFollows() {
        return this.metaFollows;
    }
}

