/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb.connection;

import com.mongodb.connection.MessageSettings;
import java.util.concurrent.atomic.AtomicInteger;
import org.bson.BsonBinaryWriter;
import org.bson.BsonBinaryWriterSettings;
import org.bson.BsonDocument;
import org.bson.BsonWriterSettings;
import org.bson.FieldNameValidator;
import org.bson.codecs.BsonValueCodecProvider;
import org.bson.codecs.Codec;
import org.bson.codecs.Encoder;
import org.bson.codecs.EncoderContext;
import org.bson.codecs.configuration.CodecRegistries;
import org.bson.codecs.configuration.CodecRegistry;
import org.bson.io.BsonOutput;

abstract class RequestMessage {
    static final AtomicInteger REQUEST_ID = new AtomicInteger(1);
    private static final int QUERY_DOCUMENT_HEADROOM = 16384;
    private static final CodecRegistry REGISTRY = CodecRegistries.fromProviders(new BsonValueCodecProvider());
    private final String collectionName;
    private final MessageSettings settings;
    private final int id;
    private final OpCode opCode;

    public static int getCurrentGlobalId() {
        return REQUEST_ID.get();
    }

    RequestMessage(OpCode opCode, MessageSettings settings) {
        this(null, opCode, settings);
    }

    RequestMessage(String collectionName, OpCode opCode, MessageSettings settings) {
        this.collectionName = collectionName;
        this.settings = settings;
        this.id = REQUEST_ID.getAndIncrement();
        this.opCode = opCode;
    }

    public int getId() {
        return this.id;
    }

    public OpCode getOpCode() {
        return this.opCode;
    }

    public String getNamespace() {
        return this.getCollectionName() != null ? this.getCollectionName() : null;
    }

    public MessageSettings getSettings() {
        return this.settings;
    }

    public RequestMessage encode(BsonOutput bsonOutput) {
        return this.encodeWithMetadata(bsonOutput).getNextMessage();
    }

    public EncodingMetadata encodeWithMetadata(BsonOutput bsonOutput) {
        int messageStartPosition = bsonOutput.getPosition();
        this.writeMessagePrologue(bsonOutput);
        EncodingMetadata encodingMetadata = this.encodeMessageBodyWithMetadata(bsonOutput, messageStartPosition);
        this.backpatchMessageLength(messageStartPosition, bsonOutput);
        return encodingMetadata;
    }

    protected void writeMessagePrologue(BsonOutput bsonOutput) {
        bsonOutput.writeInt32(0);
        bsonOutput.writeInt32(this.id);
        bsonOutput.writeInt32(0);
        bsonOutput.writeInt32(this.opCode.getValue());
    }

    protected abstract RequestMessage encodeMessageBody(BsonOutput var1, int var2);

    protected abstract EncodingMetadata encodeMessageBodyWithMetadata(BsonOutput var1, int var2);

    protected <T> void addDocument(BsonDocument document, BsonOutput bsonOutput, FieldNameValidator validator) {
        this.addDocument(document, this.getCodec(document), EncoderContext.builder().build(), bsonOutput, validator, this.settings.getMaxDocumentSize() + 16384);
    }

    protected void addCollectibleDocument(BsonDocument document, BsonOutput bsonOutput, FieldNameValidator validator) {
        this.addDocument(document, this.getCodec(document), EncoderContext.builder().isEncodingCollectibleDocument(true).build(), bsonOutput, validator, this.settings.getMaxDocumentSize());
    }

    protected void backpatchMessageLength(int startPosition, BsonOutput bsonOutput) {
        int messageLength = bsonOutput.getPosition() - startPosition;
        bsonOutput.writeInt32(bsonOutput.getPosition() - messageLength, messageLength);
    }

    protected String getCollectionName() {
        return this.collectionName;
    }

    Codec<BsonDocument> getCodec(BsonDocument document) {
        return REGISTRY.get(document.getClass());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <T> void addDocument(T obj, Encoder<T> encoder, EncoderContext encoderContext, BsonOutput bsonOutput, FieldNameValidator validator, int maxDocumentSize) {
        BsonBinaryWriter writer = new BsonBinaryWriter(new BsonWriterSettings(), new BsonBinaryWriterSettings(maxDocumentSize), bsonOutput, validator);
        try {
            encoder.encode(writer, obj, encoderContext);
        }
        finally {
            writer.close();
        }
    }

    static enum OpCode {
        OP_REPLY(1),
        OP_MSG(1000),
        OP_UPDATE(2001),
        OP_INSERT(2002),
        OP_QUERY(2004),
        OP_GETMORE(2005),
        OP_DELETE(2006),
        OP_KILL_CURSORS(2007);

        private final int value;

        private OpCode(int value) {
            this.value = value;
        }

        public int getValue() {
            return this.value;
        }
    }

    static class EncodingMetadata {
        private final RequestMessage nextMessage;
        private final int firstDocumentPosition;

        EncodingMetadata(RequestMessage nextMessage, int firstDocumentPosition) {
            this.nextMessage = nextMessage;
            this.firstDocumentPosition = firstDocumentPosition;
        }

        public RequestMessage getNextMessage() {
            return this.nextMessage;
        }

        public int getFirstDocumentPosition() {
            return this.firstDocumentPosition;
        }
    }
}

