/*
 * Decompiled with CFR 0.152.
 */
package org.mybatis.scripting.thymeleaf.expression;

import java.util.Arrays;
import java.util.Collections;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;

public class Likes {
    private char escapeChar = (char)92;
    private Set<Character> additionalEscapeTargetChars = Collections.emptySet();
    private Function<Character, String> escapeClauseSupplier = targetEscapeChar -> "ESCAPE '" + targetEscapeChar + "'";

    private Likes() {
    }

    public String escapeWildcard(String value) {
        if (value == null || value.isEmpty()) {
            return "";
        }
        StringBuilder sb = new StringBuilder(value.length() + 16);
        for (char c : value.toCharArray()) {
            if (c == this.escapeChar || c == '%' || c == '_' || this.additionalEscapeTargetChars.contains(Character.valueOf(c))) {
                sb.append(this.escapeChar);
            }
            sb.append(c);
        }
        return sb.toString();
    }

    public String escapeClause() {
        return this.escapeClauseSupplier.apply(Character.valueOf(this.escapeChar));
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public static class Builder {
        private final Likes instance = new Likes();

        private Builder() {
        }

        public Builder escapeChar(Character escapeChar) {
            Optional.ofNullable(escapeChar).ifPresent(v -> this.instance.escapeChar = v.charValue());
            return this;
        }

        public Builder additionalEscapeTargetChars(Character ... additionalEscapeTargetChars) {
            Optional.ofNullable(additionalEscapeTargetChars).ifPresent(v -> this.instance.additionalEscapeTargetChars = Arrays.stream(v).collect(Collectors.toSet()));
            return this;
        }

        public Builder escapeClauseFormat(String escapeClauseFormat) {
            Optional.ofNullable(escapeClauseFormat).ifPresent(v -> this.instance.escapeClauseSupplier = escapeChar -> String.format(v, escapeChar));
            return this;
        }

        public Likes build() {
            return this.instance;
        }
    }
}

