/*
 * Decompiled with CFR 0.152.
 */
package org.nd4j.autodiff.samediff.internal;

import java.util.Collections;
import java.util.IdentityHashMap;
import java.util.Set;
import org.nd4j.autodiff.samediff.internal.AbstractDependencyTracker;
import org.nd4j.autodiff.samediff.internal.DependencyMapIdentity;
import org.nd4j.autodiff.samediff.internal.IDependencyMap;
import org.nd4j.linalg.api.ndarray.INDArray;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IdentityDependencyTracker<T, D>
extends AbstractDependencyTracker<T, D> {
    private static final Logger log = LoggerFactory.getLogger(IdentityDependencyTracker.class);

    @Override
    protected IDependencyMap<T, D> newTMap() {
        return new DependencyMapIdentity();
    }

    @Override
    protected Set<T> newTSet() {
        return Collections.newSetFromMap(new IdentityHashMap());
    }

    @Override
    protected String toStringT(T t) {
        if (t instanceof INDArray) {
            INDArray i = (INDArray)t;
            return System.identityHashCode(t) + " - id=" + i.getId() + ", " + i.shapeInfoToString();
        }
        return System.identityHashCode(t) + " - " + t.toString();
    }

    @Override
    protected String toStringD(D d) {
        return d.toString();
    }
}

