/*
 * Decompiled with CFR 0.152.
 */
package org.nd4j.linalg.api.ops.random.impl;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import lombok.NonNull;
import org.nd4j.autodiff.samediff.SDVariable;
import org.nd4j.autodiff.samediff.SameDiff;
import org.nd4j.imports.NoOpNameFoundException;
import org.nd4j.linalg.api.buffer.DataType;
import org.nd4j.linalg.api.ndarray.INDArray;
import org.nd4j.linalg.api.ops.OpContext;
import org.nd4j.linalg.api.ops.random.BaseRandomOp;
import org.nd4j.linalg.api.shape.LongShapeDescriptor;
import org.nd4j.linalg.factory.Nd4j;

public class Linspace
extends BaseRandomOp {
    private double from;
    private double to;
    private double step;
    private long length;

    public Linspace() {
    }

    public Linspace(double from, long length, double step, DataType dataType) {
        this(Nd4j.createUninitialized(dataType, new long[]{length}, Nd4j.order().charValue()), from, from, step);
    }

    public Linspace(double from, double to, long length, DataType dataType) {
        this(Nd4j.createUninitialized(dataType, new long[]{length}, Nd4j.order().charValue()), from, to);
    }

    public Linspace(@NonNull INDArray z, double from, double to) {
        super(null, null, z);
        if (z == null) {
            throw new NullPointerException("z is marked non-null but is null");
        }
        this.from = from;
        this.to = to;
        this.length = z.length();
        double step = 0.0;
        this.extraArgs = new Object[]{from, to, step};
    }

    public Linspace(@NonNull INDArray z, double from, double to, double step) {
        super(null, null, z);
        if (z == null) {
            throw new NullPointerException("z is marked non-null but is null");
        }
        this.from = from;
        this.to = to;
        this.length = z.length();
        this.step = step;
        this.extraArgs = new Object[]{from, to, step};
    }

    public Linspace(SameDiff sd, double from, double to, long length) {
        super(sd, new long[]{length});
        this.sameDiff = sd;
        this.from = from;
        this.to = to;
        this.length = length;
        double step = 0.0;
        this.extraArgs = new Object[]{from, to, step};
    }

    @Override
    public int opNum() {
        return 4;
    }

    @Override
    public String opName() {
        return "linspace_random";
    }

    @Override
    public INDArray x() {
        return null;
    }

    @Override
    public INDArray y() {
        return null;
    }

    @Override
    public void setX(INDArray x) {
        this.x = null;
    }

    @Override
    public void setY(INDArray y) {
        this.y = null;
    }

    @Override
    public String onnxName() {
        throw new NoOpNameFoundException("No onnx op opName found for " + this.opName());
    }

    @Override
    public String tensorflowName() {
        throw new NoOpNameFoundException("No tensorflow op opName found for " + this.opName());
    }

    @Override
    public List<LongShapeDescriptor> calculateOutputShape(OpContext oc) {
        return this.calculateOutputShape();
    }

    @Override
    public List<LongShapeDescriptor> calculateOutputShape() {
        LongShapeDescriptor longShapeDescriptor = LongShapeDescriptor.fromShape(this.shape, this.dataType);
        return Arrays.asList(longShapeDescriptor);
    }

    @Override
    public List<SDVariable> doDiff(List<SDVariable> f1) {
        return Collections.emptyList();
    }
}

