/*
 * Decompiled with CFR 0.152.
 */
package org.nd4j.linalg.indexing;

import org.nd4j.common.base.Preconditions;
import org.nd4j.linalg.api.ndarray.INDArray;
import org.nd4j.linalg.indexing.INDArrayIndex;
import org.nd4j.shade.guava.primitives.Longs;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IntervalIndex
implements INDArrayIndex {
    private static final Logger log = LoggerFactory.getLogger(IntervalIndex.class);
    protected long begin;
    protected long end;
    protected boolean inclusive;
    protected long stride = 1L;
    protected long index = 0L;
    protected long length = 0L;
    protected boolean initialized = false;

    private IntervalIndex() {
    }

    public IntervalIndex(boolean inclusive, long stride) {
        this.inclusive = inclusive;
        this.stride = stride;
    }

    @Override
    public long end() {
        return this.end;
    }

    @Override
    public long offset() {
        return this.begin;
    }

    @Override
    public long length() {
        return this.length;
    }

    @Override
    public long stride() {
        return this.stride;
    }

    @Override
    public void reverse() {
        long oldBegin;
        long oldEnd = this.end;
        this.end = oldBegin = this.begin;
        this.begin = oldEnd;
    }

    @Override
    public boolean isInterval() {
        return true;
    }

    @Override
    public void init(INDArray arr, long begin, int dimension) {
        if (begin < 0L) {
            begin += (long)arr.rank();
        }
        this.begin = begin;
        this.index = begin;
        this.end = this.inclusive ? arr.size(dimension) + 1L : arr.size(dimension);
        long endInc = arr.size(dimension) - (long)(this.inclusive ? 0 : 1);
        this.length = (endInc - begin) / this.stride + 1L;
        this.initialized = true;
        Preconditions.checkState((endInc < arr.size(dimension) ? 1 : 0) != 0, (String)"Invalid interval: %s on array with shape %ndShape", (Object)this, (Object)arr);
    }

    @Override
    public void init(INDArray arr, int dimension) {
        this.init(arr, 0L, dimension);
    }

    @Override
    public void init(long begin, long end, long max) {
        if (begin < 0L) {
            begin += max;
        }
        if (end < 0L) {
            end += max;
        }
        this.begin = begin;
        this.index = begin;
        this.end = end;
        long endInc = end - (long)(this.inclusive ? 0 : 1);
        this.length = (endInc - begin) / this.stride + 1L;
        this.initialized = true;
    }

    @Override
    public void init(long begin, long end) {
        if (begin < 0L || end < 0L) {
            this.begin = begin;
            this.end = end;
            log.debug("Not initializing due to missing positive dimensions. Initialization will be attempted again during runtime.");
            return;
        }
        this.begin = begin;
        this.index = begin;
        this.end = end;
        long endInc = end - (long)(this.inclusive ? 0 : 1);
        this.length = (endInc - begin) / this.stride + 1L;
        this.initialized = true;
    }

    @Override
    public boolean initialized() {
        return this.initialized && this.begin >= 0L && this.end >= 0L;
    }

    @Override
    public INDArrayIndex dup() {
        IntervalIndex intervalIndex = new IntervalIndex();
        intervalIndex.initialized = this.initialized;
        intervalIndex.end = this.end;
        intervalIndex.begin = this.begin;
        intervalIndex.inclusive = this.inclusive;
        intervalIndex.index = this.index;
        intervalIndex.length = this.length;
        intervalIndex.stride = this.stride;
        return intervalIndex;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof IntervalIndex)) {
            return false;
        }
        IntervalIndex that = (IntervalIndex)o;
        if (this.begin != that.begin) {
            return false;
        }
        if (this.end != that.end) {
            return false;
        }
        if (this.inclusive != that.inclusive) {
            return false;
        }
        if (this.stride != that.stride) {
            return false;
        }
        return this.index == that.index;
    }

    public int hashCode() {
        int result = Longs.hashCode((long)this.begin);
        result = 31 * result + Longs.hashCode((long)this.end);
        result = 31 * result + (this.inclusive ? 1 : 0);
        result = 31 * result + Longs.hashCode((long)this.stride);
        result = 31 * result + Longs.hashCode((long)this.index);
        return result;
    }

    public String toString() {
        return "Interval(b=" + this.begin + ",e=" + this.end + ",s=" + this.stride + (this.inclusive ? ",inclusive" : "") + ")";
    }

    public boolean isInclusive() {
        return this.inclusive;
    }
}

