/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.internal.kernel.api.helpers;

import org.neo4j.graphdb.Direction;
import org.neo4j.internal.kernel.api.NodeCursor;
import org.neo4j.storageengine.api.RelationshipSelection;

public final class Nodes {
    private Nodes() {
        throw new UnsupportedOperationException("Do not instantiate");
    }

    public static int countOutgoing(NodeCursor nodeCursor) {
        return Nodes.count(nodeCursor, Direction.OUTGOING);
    }

    public static int countOutgoing(NodeCursor nodeCursor, int type) {
        return Nodes.count(nodeCursor, type, Direction.OUTGOING);
    }

    public static int countIncoming(NodeCursor nodeCursor) {
        return Nodes.count(nodeCursor, Direction.INCOMING);
    }

    public static int countIncoming(NodeCursor nodeCursor, int type) {
        return Nodes.count(nodeCursor, type, Direction.INCOMING);
    }

    public static int countAll(NodeCursor nodeCursor) {
        return Nodes.count(nodeCursor, Direction.BOTH);
    }

    public static int countAll(NodeCursor nodeCursor, int type) {
        return Nodes.count(nodeCursor, type, Direction.BOTH);
    }

    public static int count(NodeCursor nodeCursor, int type, Direction direction) {
        return nodeCursor.degree(RelationshipSelection.selection((int)type, (Direction)direction));
    }

    public static int count(NodeCursor nodeCursor, Direction direction) {
        return nodeCursor.degree(RelationshipSelection.selection((Direction)direction));
    }

    public static int countWithMax(int maxDegree, NodeCursor nodeCursor, Direction direction) {
        return nodeCursor.degreeWithMax(maxDegree, RelationshipSelection.selection((Direction)direction));
    }

    public static int countWithMax(int maxDegree, NodeCursor nodeCursor, int type, Direction direction) {
        return nodeCursor.degreeWithMax(maxDegree, RelationshipSelection.selection((int)type, (Direction)direction));
    }
}

