/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.api.impl.schema;

import java.util.function.Supplier;
import org.apache.lucene.index.IndexWriterConfig;
import org.neo4j.configuration.Config;
import org.neo4j.configuration.helpers.DatabaseReadOnlyChecker;
import org.neo4j.internal.schema.IndexDescriptor;
import org.neo4j.kernel.api.impl.index.IndexWriterConfigs;
import org.neo4j.kernel.api.impl.index.builder.AbstractLuceneIndexBuilder;
import org.neo4j.kernel.api.impl.index.partition.WritableIndexPartitionFactory;
import org.neo4j.kernel.api.impl.index.storage.PartitionedIndexStorage;
import org.neo4j.kernel.api.impl.schema.SchemaIndex;
import org.neo4j.kernel.api.impl.schema.WritableDatabaseSchemaIndex;
import org.neo4j.kernel.impl.api.index.IndexSamplingConfig;

public class LuceneSchemaIndexBuilder
extends AbstractLuceneIndexBuilder<LuceneSchemaIndexBuilder> {
    private final IndexDescriptor descriptor;
    private IndexSamplingConfig samplingConfig;
    private Supplier<IndexWriterConfig> writerConfigFactory;

    private LuceneSchemaIndexBuilder(IndexDescriptor descriptor, DatabaseReadOnlyChecker readOnlyChecker, Config config) {
        super(readOnlyChecker);
        this.descriptor = descriptor;
        this.samplingConfig = new IndexSamplingConfig(config);
        this.writerConfigFactory = () -> IndexWriterConfigs.standard(config);
    }

    public static LuceneSchemaIndexBuilder create(IndexDescriptor descriptor, DatabaseReadOnlyChecker readOnlyChecker, Config config) {
        return new LuceneSchemaIndexBuilder(descriptor, readOnlyChecker, config);
    }

    public LuceneSchemaIndexBuilder withSamplingConfig(IndexSamplingConfig samplingConfig) {
        this.samplingConfig = samplingConfig;
        return this;
    }

    public LuceneSchemaIndexBuilder withWriterConfig(Supplier<IndexWriterConfig> writerConfigFactory) {
        this.writerConfigFactory = writerConfigFactory;
        return this;
    }

    public SchemaIndex build() {
        PartitionedIndexStorage storage = this.storageBuilder.build();
        return new WritableDatabaseSchemaIndex(storage, this.descriptor, this.samplingConfig, new WritableIndexPartitionFactory(this.writerConfigFactory), this.readOnlyChecker);
    }
}

