/*
 * Decompiled with CFR 0.152.
 */
package org.noear.liquor.eval;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.StringReader;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.locks.ReentrantLock;
import org.noear.liquor.DynamicClassLoader;
import org.noear.liquor.DynamicCompiler;
import org.noear.liquor.eval.CodeSpec;
import org.noear.liquor.eval.Evaluator;
import org.noear.liquor.eval.Execable;
import org.noear.liquor.eval.ExecableImpl;

public class LiquorEvaluator
implements Evaluator {
    private static final Evaluator instance = new LiquorEvaluator(null);
    private boolean printable = false;
    private final DynamicCompiler compiler;
    private final DynamicClassLoader cachedClassLoader;
    private DynamicClassLoader tempClassLoader;
    private int tempCount = 0;
    private final List<String> globalImports = new ArrayList<String>();
    private final Map<CodeSpec, Execable> cachedMap = new ConcurrentHashMap<CodeSpec, Execable>();
    private final Map<CodeSpec, Long> nameMap = new ConcurrentHashMap<CodeSpec, Long>();
    private final AtomicLong nameIdx = new AtomicLong(0L);
    private final ReentrantLock lock = new ReentrantLock();

    public static Evaluator getInstance() {
        return instance;
    }

    public LiquorEvaluator(ClassLoader parentClassLoader) {
        this.compiler = new DynamicCompiler(parentClassLoader);
        this.cachedClassLoader = this.compiler.getClassLoader();
        this.tempClassLoader = this.compiler.newClassLoader();
    }

    protected Class<?> build(CodeSpec codeSpec) {
        boolean isCached = codeSpec.isCached();
        this.lock.lock();
        try {
            if (isCached) {
                this.compiler.setClassLoader(this.cachedClassLoader);
            } else {
                if (this.tempCount++ > 10000) {
                    this.tempClassLoader = this.compiler.newClassLoader();
                    this.tempCount = 0;
                }
                this.compiler.setClassLoader(this.tempClassLoader);
            }
            String clazzName = this.addSource(codeSpec);
            this.compiler.build();
            Class clazz = this.compiler.getClassLoader().loadClass(clazzName);
            return clazz;
        }
        catch (Exception e) {
            throw new IllegalStateException(e);
        }
        finally {
            this.lock.unlock();
        }
    }

    protected Map<CodeSpec, Class<?>> build(List<CodeSpec> codeSpecs) {
        boolean isCached = codeSpecs.get(0).isCached();
        this.lock.lock();
        try {
            if (isCached) {
                this.compiler.setClassLoader(this.cachedClassLoader);
            } else {
                if (this.tempCount++ > 10000) {
                    this.tempClassLoader = this.compiler.newClassLoader();
                    this.tempCount = 0;
                }
                this.compiler.setClassLoader(this.tempClassLoader);
            }
            HashMap<CodeSpec, String> clazzNameMap = new HashMap<CodeSpec, String>();
            for (CodeSpec codeSpec : codeSpecs) {
                String clazzName = this.addSource(codeSpec);
                clazzNameMap.put(codeSpec, clazzName);
            }
            this.compiler.build();
            HashMap clazzMap = new HashMap();
            for (Map.Entry entry : clazzNameMap.entrySet()) {
                Class clazz = this.compiler.getClassLoader().loadClass((String)entry.getValue());
                clazzMap.put(entry.getKey(), clazz);
            }
            HashMap hashMap = clazzMap;
            return hashMap;
        }
        catch (Exception e) {
            throw new IllegalStateException(e);
        }
        finally {
            this.lock.unlock();
        }
    }

    protected String addSource(CodeSpec codeSpec) {
        TreeSet<String> importBuilder = new TreeSet<String>();
        StringBuilder codeBuilder = new StringBuilder();
        for (String imp : this.globalImports) {
            importBuilder.add("import " + imp + ";\n");
        }
        for (String imp : codeSpec.getImports()) {
            importBuilder.add("import " + imp + ";\n");
        }
        if (codeSpec.getCode().contains("import ")) {
            BufferedReader reader = new BufferedReader(new StringReader(codeSpec.getCode()));
            try {
                String line;
                while ((line = reader.readLine()) != null) {
                    String lineTrim = line.trim();
                    if (lineTrim.startsWith("import ")) {
                        importBuilder.add((String)lineTrim + "\n");
                        continue;
                    }
                    codeBuilder.append(line).append("\n");
                }
            }
            catch (IOException e) {
                throw new IllegalStateException(e);
            }
        } else {
            codeBuilder.append(codeSpec.getCode());
        }
        String clazzName = "Execable$" + this.getKey(codeSpec);
        StringBuilder code = new StringBuilder();
        if (importBuilder.size() > 0) {
            for (String impCode : importBuilder) {
                code.append(impCode);
            }
            code.append("\n");
        }
        code.append("public class ").append(clazzName).append(" {\n");
        code.append("  public static ");
        if (codeSpec.getReturnType() != null) {
            code.append(codeSpec.getReturnType().getCanonicalName());
        } else {
            code.append("void");
        }
        code.append(" _main$(");
        if (codeSpec.getParameters() != null && codeSpec.getParameters().length > 0) {
            for (int i = 0; i < codeSpec.getParameters().length; ++i) {
                Map.Entry<String, Class<?>> kv = codeSpec.getParameters()[i];
                code.append(kv.getValue().getCanonicalName()).append(" ").append(kv.getKey()).append(",");
            }
            code.setLength(code.length() - 1);
        }
        code.append(") throws Throwable\n");
        code.append("  {\n");
        if (codeSpec.getCode().indexOf(59) < 0) {
            code.append("    return ").append(codeSpec.getCode()).append(";\n");
        } else {
            code.append("    ").append((CharSequence)codeBuilder).append("\n");
        }
        code.append("  }\n");
        code.append("}");
        if (this.printable) {
            System.out.println("-- Start(" + clazzName + ") --");
            System.out.println(code);
            System.out.println("-- End(" + clazzName + ") --");
        }
        this.compiler.addSource(clazzName, code.toString());
        return clazzName;
    }

    @Override
    public void printable(boolean printable) {
        this.printable = printable;
    }

    public void globalImports(Class<?> ... classes) {
        for (Class<?> clz : classes) {
            this.globalImports.add(clz.getCanonicalName());
        }
    }

    public void globalImports(String ... imports) {
        for (String imp : imports) {
            this.globalImports.add(imp);
        }
    }

    protected Long getKey(CodeSpec codeSpec) {
        if (!codeSpec.isCached()) {
            return this.nameIdx.incrementAndGet();
        }
        return this.nameMap.computeIfAbsent(codeSpec, k -> this.nameIdx.incrementAndGet());
    }

    @Override
    public Execable compile(CodeSpec codeSpec) {
        if (codeSpec == null) {
            throw new IllegalArgumentException("The codeSpec parameter is null");
        }
        if (!codeSpec.isCached()) {
            return new ExecableImpl(this.build(codeSpec));
        }
        return this.cachedMap.computeIfAbsent(codeSpec, k -> new ExecableImpl(this.build(codeSpec)));
    }

    @Override
    public Map<CodeSpec, Execable> compile(List<CodeSpec> codeSpecs) {
        if (codeSpecs == null || codeSpecs.size() == 0) {
            throw new IllegalArgumentException("The codeSpecs parameter is empty");
        }
        HashMap<CodeSpec, Execable> execableMap = new HashMap<CodeSpec, Execable>();
        if (!codeSpecs.get(0).isCached()) {
            for (Map.Entry<CodeSpec, Class<?>> entry : this.build(codeSpecs).entrySet()) {
                execableMap.put(entry.getKey(), new ExecableImpl(entry.getValue()));
            }
        } else {
            ArrayList<CodeSpec> codeSpecs2 = new ArrayList<CodeSpec>();
            for (CodeSpec codeSpec : codeSpecs) {
                Execable execable2 = this.cachedMap.get(codeSpec);
                if (execable2 == null) {
                    codeSpecs2.add(codeSpec);
                    continue;
                }
                execableMap.put(codeSpec, execable2);
            }
            for (Map.Entry entry : this.build(codeSpecs).entrySet()) {
                ExecableImpl execable1 = new ExecableImpl((Class)entry.getValue());
                this.cachedMap.put((CodeSpec)entry.getKey(), execable1);
                execableMap.put((CodeSpec)entry.getKey(), execable1);
            }
        }
        return execableMap;
    }

    @Override
    public Object eval(CodeSpec codeSpec, Object ... args) throws InvocationTargetException {
        if (codeSpec == null) {
            throw new IllegalArgumentException("The codeSpec parameter is null");
        }
        try {
            return this.compile(codeSpec).exec(args);
        }
        catch (InvocationTargetException e) {
            throw e;
        }
        catch (Exception e) {
            throw new InvocationTargetException(e);
        }
    }
}

