/*
 * Decompiled with CFR 0.152.
 */
package org.noear.liquor;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.noear.liquor.MemoryByteCode;

public class DynamicClassLoader
extends ClassLoader {
    private final Map<String, MemoryByteCode> byteCodes = new HashMap<String, MemoryByteCode>();

    public DynamicClassLoader(ClassLoader classLoader) {
        super(classLoader != null ? classLoader : Thread.currentThread().getContextClassLoader());
    }

    protected void registerCompiledSource(MemoryByteCode byteCode) {
        this.byteCodes.put(byteCode.getClassName(), byteCode);
    }

    protected Class<?> defineClass(MemoryByteCode byteCode) {
        byteCode.defined = true;
        byte[] bytes = byteCode.getByteCode();
        return super.defineClass(byteCode.getClassName(), bytes, 0, bytes.length);
    }

    @Override
    protected Class<?> findClass(String name) throws ClassNotFoundException {
        MemoryByteCode byteCode = this.byteCodes.get(name);
        if (byteCode == null || byteCode.defined) {
            return super.findClass(name);
        }
        return this.defineClass(byteCode);
    }

    protected void prepareClasses() {
        for (MemoryByteCode byteCode : this.byteCodes.values()) {
            if (byteCode.defined) continue;
            this.defineClass(byteCode);
        }
    }

    public Collection<String> getClassNames() {
        return this.byteCodes.keySet();
    }

    public int size() {
        return this.byteCodes.size();
    }
}

