/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.netconf.mdsal.connector;

import com.google.common.base.Preconditions;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.mdsal.dom.api.DOMSchemaService;
import org.opendaylight.netconf.api.capability.Capability;
import org.opendaylight.netconf.api.monitoring.CapabilityListener;
import org.opendaylight.netconf.mdsal.connector.MdsalNetconfOperationServiceFactory;
import org.opendaylight.yangtools.concepts.Registration;
import org.opendaylight.yangtools.yang.model.api.EffectiveModelContext;
import org.opendaylight.yangtools.yang.model.api.EffectiveModelContextListener;
import org.opendaylight.yangtools.yang.model.api.SchemaContext;
import org.opendaylight.yangtools.yang.model.repo.api.YangTextSchemaSource;
import org.opendaylight.yangtools.yang.model.repo.spi.SchemaSourceProvider;

public class CurrentSchemaContext
implements EffectiveModelContextListener,
AutoCloseable {
    private final AtomicReference<EffectiveModelContext> currentContext = new AtomicReference();
    private final Set<CapabilityListener> listeners1 = Collections.synchronizedSet(new HashSet());
    private final SchemaSourceProvider<YangTextSchemaSource> rootSchemaSourceProvider;
    private Registration schemaContextListenerListenerRegistration;

    private CurrentSchemaContext(SchemaSourceProvider<YangTextSchemaSource> rootSchemaSourceProvider) {
        this.rootSchemaSourceProvider = rootSchemaSourceProvider;
    }

    public static CurrentSchemaContext create(DOMSchemaService schemaService, SchemaSourceProvider<YangTextSchemaSource> rootSchemaSourceProvider) {
        CurrentSchemaContext context = new CurrentSchemaContext(rootSchemaSourceProvider);
        Registration registration = schemaService.registerSchemaContextListener((EffectiveModelContextListener)context);
        context.setRegistration(registration);
        return context;
    }

    private void setRegistration(Registration registration) {
        this.schemaContextListenerListenerRegistration = registration;
    }

    public @NonNull EffectiveModelContext getCurrentContext() {
        EffectiveModelContext ret = this.currentContext.get();
        Preconditions.checkState((ret != null ? 1 : 0) != 0, (Object)"Current context not received");
        return ret;
    }

    public void onModelContextUpdated(EffectiveModelContext schemaContext) {
        this.currentContext.set(schemaContext);
        Set<Capability> addedCaps = MdsalNetconfOperationServiceFactory.transformCapabilities((SchemaContext)this.currentContext.get(), this.rootSchemaSourceProvider);
        for (CapabilityListener listener : this.listeners1) {
            listener.onCapabilitiesChanged(addedCaps, Set.of());
        }
    }

    @Override
    public void close() {
        this.listeners1.clear();
        this.schemaContextListenerListenerRegistration.close();
        this.currentContext.set(null);
    }

    public Registration registerCapabilityListener(CapabilityListener listener) {
        listener.onCapabilitiesChanged(MdsalNetconfOperationServiceFactory.transformCapabilities((SchemaContext)this.currentContext.get(), this.rootSchemaSourceProvider), Set.of());
        this.listeners1.add(listener);
        return () -> this.listeners1.remove(listener);
    }
}

